// Video.js
import React from "react";
import "./Styles.css";

function Video({ videoResponse }) {
  console.log(videoResponse);
  // Function to handle the download button click
  const handleDownloadClick = () => {
    const a = document.createElement("a");
    a.href = videoResponse;
    a.download = "video.mp4"; // Set the default download file name
    a.style.display = "none"; // Hide the anchor element
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
  };

  return (
    <div className="video-container">
      <h2 className="sub-heading">Video</h2>
      {/* <div className="video-container">{videoResponse}</div>{" "} */}
      <div>
        <video
          // width="320"
          height="425"
          controls
          key={videoResponse}
        >
          <source src={videoResponse} type="video/mp4" />
        </video>
      </div>
      <div>
        <button className="button" onClick={handleDownloadClick}>
          Download
        </button>
      </div>
      {/* Display the video response */}
    </div>
  );
}

export default Video;
