// Summary.js
import React, { useEffect, useState } from "react";
import Video from "./Video";
import Audio from "./Audio";

function Summary({ summary, requestId }) {
  const [audioResponse, setAudioResponse] = useState(""); // State to store video response
  // const [audioDisplay, setAudioDisplay] = useState("");
  const [loading, setLoading] = useState(false);
  // console.log(requestId);

  const handleGetAudio = async () => {
    if (summary) {
      setLoading(true);
      let request_id = requestId;
      // console.log(summary);
      // console.log(request_id);
      let text = summary;
      try {
        // 34.41.231.47:8000

        const response = await fetch(
          "https://texttovideo.ns-devsecops.com/get_audio",
          {
            method: "POST",
            headers: {
              "Content-Type": "application/json",
            },
            body: JSON.stringify({ text, request_id }), // Send the summary as the request
          }
        );
        if (response.ok) {
          const data = await response.json(); // Assuming the response is text
          // console.log(data);
          // console.log(data.audio);
          // const audioObjectUrl = URL.createObjectURL(data.audio);
          // console.log(audioObjectUrl);
          setAudioResponse(data.audio);
          // setAudioDisplay()
          // console.log(audioResponse);
        } else {
          console.error("Failed to fetch video");
        }
      } catch (error) {
        console.error("Error:", error);
      } finally {
        setLoading(false);
      }
    }
  };

  useEffect(() => {
    // console.log("Updated audioResponse:", audioResponse);
  }, [audioResponse]);

  return (
    <div className="container">
      <div className="summary-container">
        <h2 className="sub-heading">Summary</h2>
        <div>
          <textarea
            className="summary-texarea"
            // rows="6"
            // cols="120"
            value={summary}
            readOnly
            placeholder="Summary will display here..."
          />
        </div>
        {loading ? (
          <div>
            <button className="generating-button">Generating...</button>
          </div>
        ) : (
          <div>
            <button className="button" onClick={handleGetAudio}>
              Get Audio
            </button>
          </div>
        )}
      </div>

      <Audio audioResponse={audioResponse} requestId={requestId} />
      {/* Pass videoResponse as prop */}
    </div>
  );
}

export default Summary;
