// Summary.js
import React, { useEffect, useState } from "react";
import Video from "./Video";
import Audio from "./Audio";

function Summary({
  summary,
  translatedSummary,
  translatedSummaryLang,
  requestId,
}) {
  const [audioResponse, setAudioResponse] = useState("");
  // const [audioDisplay, setAudioDisplay] = useState("");
  const [loading, setLoading] = useState(false);
  const [selectedSummary, setSelectedSummary] = useState(null);
  // console.log(requestId);

  console.log(summary);
  console.log(translatedSummary);

  // summary = "hello summary";
  // translatedSummary = "hello transalted summary";

  const handleGetAudio = async () => {
    // if selected for audio lang = eng or default
    // summary
    // else
    // translatedSummary,
    //   translatedSummaryLang,
    // console.log(selectedSummary);
    if (!selectedSummary) {
      alert("Please select a checkbox for an audio language");
      return; // Exit the function if selectedSummary is null
    }
    if (selectedSummary) {
      setLoading(true);
      let request_id = requestId;
      // console.log(summary);
      // console.log(request_id);
      // let text = summary;
      let text = selectedSummary;
      // console.log(selectedSummary);
      let audio_language = "";
      if (selectedSummary === translatedSummary) {
        audio_language = translatedSummaryLang;
      } else {
        audio_language = "en_XX";
      }
      let voice_gender = "M";
      // console.log(audio_language);
      try {
        // 34.41.231.47:8000

        const response = await fetch(
          "https://texttovideo.ns-devsecops.com/get_audio",
          {
            method: "POST",
            headers: {
              "Content-Type": "application/json",
            },
            body: JSON.stringify({
              text,
              request_id,
              audio_language,
              voice_gender,
            }), // Send the summary as the request
          }
        );
        if (response.ok) {
          const data = await response.json(); // Assuming the response is text
          // console.log(data);
          // console.log(data.audio);
          // const audioObjectUrl = URL.createObjectURL(data.audio);
          // console.log(audioObjectUrl);
          setAudioResponse(data.audio);
          // setAudioDisplay()
          // console.log(audioResponse);
        } else {
          console.error("Failed to fetch video");
        }
      } catch (error) {
        console.error("Error:", error);
      } finally {
        setLoading(false);
      }
    }
  };

  useEffect(() => {
    // console.log("Updated audioResponse:", audioResponse);
  }, [audioResponse]);

  const handleCheckboxChange = (event) => {
    setSelectedSummary(event.target.value);
  };

  return (
    <div className="container">
      <div className="summary-container">
        <h2 className="sub-heading">Summary</h2>
        <p className="description">
          **Select a checkbox to get the audio output in particular language**
        </p>
        <div className="summary-content-container">
          <div className="summary-sub-container">
            <input
              type="checkbox"
              value={summary}
              checked={selectedSummary === summary}
              onChange={handleCheckboxChange}
            />
            <textarea
              className="summary-texarea"
              // rows="6"
              // cols="120"
              value={summary}
              readOnly
              placeholder="Summary will display here..."
            />
          </div>
          <div className="summary-sub-container">
            <input
              type="checkbox"
              value={translatedSummary}
              checked={selectedSummary === translatedSummary}
              onChange={handleCheckboxChange}
            />
            <textarea
              className="summary-texarea"
              // rows="6"
              // cols="120"
              value={translatedSummary}
              readOnly
              placeholder="Translated Summary will display here..."
            />
          </div>
        </div>
        {loading ? (
          <div>
            <button className="generating-button">Generating...</button>
          </div>
        ) : (
          <div>
            <button className="button" onClick={handleGetAudio}>
              Get Audio
            </button>
          </div>
        )}
      </div>

      <Audio audioResponse={audioResponse} requestId={requestId} />
      {/* Pass videoResponse as prop */}
    </div>
  );
}

export default Summary;
