import { useState } from "react";
import Summary from "./Summary";

function News() {
  const [text, setText] = useState("");
  const [summary, setSummary] = useState("");
  const [loading, setLoading] = useState(false);
  const [request_id, setRequestId] = useState(null);

  // let random_num = Math.floor(Math.random() * 1000);
  // let request_id = random_num;
  // let request_id = 123;

  function processNewsText(rawText) {
    // Replace " with '
    let news = rawText.replace(/"/g, "'");

    // Replace \n with space
    news = news.replace(/\n/g, " ");

    // Replace \t with space
    news = news.replace(/\t/g, " ");

    // Replace \r with space
    news = news.replace(/\r/g, " ");

    // Replace ; with space
    news = news.replace(/;/g, " ");

    // Replace # with space
    news = news.replace(/#/g, " ");

    // Replace -- with space
    news = news.replace(/--/g, " ");

    // Replace - with space
    news = news.replace(/-/g, " ");

    // Replace () with space
    news = news.replace(/\(/g, " ");
    news = news.replace(/\)/g, " ");

    return news;
  }

  const handleGetSummary = async () => {
    if (text) {
      setLoading(true);
      // let request_id = 123;
      let request_id = Math.floor(Math.random() * 1000);
      setRequestId(request_id);
      // console.log("Text>>>> ", text);
      processNewsText = await processNewsText(text);
      // console.log(processNewsText);
      // console.log(request_id);

      // Set a flag to track if a response has been received
      let responseReceived = false;

      // Set a timeout of 40 seconds (40,000 milliseconds)
      const timeout = 90000;

      const timeoutId = setTimeout(() => {
        if (!responseReceived) {
          // Alert the user if no response has been received within the timeout
          alert(
            "Server is Busy processing another request. We have put you on queue!"
          );
          setLoading(false); // Reset loading state
        }
      }, timeout);

      try {
        const response = await fetch("https://34.41.231.47:8000/summarize", {
          method: "POST",
          headers: {
            "Content-Type": "application/json",
          },
          body: JSON.stringify({ text: processNewsText, request_id }),
        });
        if (response.ok) {
          clearTimeout(timeoutId); // Clear the timeout if response is received
          const data = await response.json();
          // console.log(data);
          setSummary(data.summary);
          responseReceived = true;
        } else {
          console.error("Failed to fetch summary");
        }
      } catch (error) {
        console.error("Error:", error);
      } finally {
        setLoading(false);
      }
    } else {
      alert("Please enter news!!");
    }
  };

  // request_id = request_id;
  // console.log(request_id);

  const fillWithSampleData = () => {
    const sampleText = `New Delhi (India), August 29: Niveus Solutions, a cloud engineering organization, announced today that it has received the 2023 Google Cloud Partner of the Year Awards for two categories: Google Cloud Services Partner of the Year - Asia Pacific' and 'Google Cloud Expansion Partner of the Year - Asia Pacific'. This marks the second time that Niveus has been recognized by Google Cloud for their outstanding achievements.
      
    Niveus Solutions was recognized for its achievements in the Google Cloud ecosystem, helping customers across BFSI, Automotive, Media & Entertainment, Manufacturing, PSUs, and Digital Natives industries. Nievus is also recognized for its deep cloud transformation experience within the Asia Pacific region and its comprehensive and compelling digital solutions that are transforming the way industries work.
      
    "Google Cloud's partner awards recognize the significant impact and customer success that our partners have driven over the past year," said Kevin Ichhpurani, Corporate Vice President of global Ecosystem and Channels at Google Cloud. "We're delighted to recognize Niveus Solutions as a 2023 Google Cloud Partner Award winner, and look forward to a continued strong partnership in support of our mutual customers."
      
    The Google Cloud Service Partner of the Year - Asia Pacific award recognizes Niveus' commitment to enabling global innovators across diverse industries in their digital transformation. With exceptional technical capabilities and top-tier service offerings, Niveus is committed to delivering outstanding Google Cloud products and solutions as a Service Partner. Niveus' recognition as the Google Cloud Expansion Partner of the Year - Asia Pacific is a testament to its focus on driving growth and expansion throughout the region. Leveraging Google Cloud, Niveus facilitates the seamless adoption and implementation of cloud solutions, empowering businesses to scale rapidly and capitalize on new opportunities.
      
    "We're proud of the achievements we've made in the previous year and are excited to be named Google Cloud Services Partner of the Year - Asia Pacific and Google Cloud Expansion Partner of the Year - Asia Pacific. We are recognized for our strong partnership with Google Cloud and our best-in-class use of Google Cloud products and services, coupled with our expertise. Winning this prestigious award is a true testament to our agility, innovative leadership, exceptional customer service, and the remarkable growth that we have achieved," said Suyog Shetty, CEO of Niveus Solutions.
      
    In the previous year, Niveus achieved Infrastructure, Application development, and Data Management Specializations, acquiring 21 new areas of expertise and 167 Professional Google Cloud certifications. They were also recognized as a Google Cloud Regional AlloyDB partner. Notably, their collaboration on an automotive bookings platform resulted in record-breaking sales and improved customer satisfaction. Niveus expanded its team to over 900+ employees across 6+ locations and successfully entered the SEA market. They aim to replicate their success in India with Google in other international markets. Niveus strengthened its presence in the BFSI & DN space and expanded sales capacity to cover other industries like Manufacturing, CPG, and Conglomerates, successfully closing deals with various clients.
      
    Niveus Solutions Pvt. Ltd. is a cloud-born engineering services organization founded in 2013. Niveus progressed rapidly over the years with the company making a strategic decision in 2019 to exclusively partner with Google Cloud, securing 'Premier Partner status in less than 2 years. Niveus empowers enterprises to harness the power of cloud services and build resilient infrastructures that scale. Niveus specializes in application, infrastructure, & data modernization, data management, cloud consulting, security, & managed services.
    `;
    setText(sampleText);
  };

  //   let request_id = request_id;

  return (
    <div className="container">
      <div className="news-container">
        <h2 className="sub-heading">News</h2>
        <div className="sample-container">
          <label className="sample">
            <input
              type="checkbox"
              name="sampleData"
              onClick={fillWithSampleData}
            />
            Sample
          </label>
        </div>
        <div className="textarea-container">
          <textarea
            // rows="16"
            // cols="120"
            value={text}
            onChange={(e) => setText(e.target.value)}
            placeholder="Enter news text here..."
          />
        </div>
        {loading ? (
          <div>
            <button className="generating-button">Generating...</button>
          </div>
        ) : (
          <div>
            <button className="button" onClick={handleGetSummary}>
              Get Summary
            </button>
          </div>
        )}
      </div>

      <Summary summary={summary} requestId={request_id} />
    </div>
  );
}

export default News;
