import React, { useEffect, useState } from "react";
import "./Styles.css";
import Video from "./Video";
import Loading from "./Loading";

function Audio({ audioResponse, requestId }) {
  const [videoResponse, setVideoResponse] = useState("");
  const [audioUrl, setAudioUrl] = useState("");
  const [loading, setLoading] = useState("");
  const [timer, setTimer] = useState(0); // Timer in seconds

  // console.log(requestId);

  const handleGetVideo = async () => {
    if (audioResponse) {
      setLoading(true);
      setTimer(0); // Reset the timer
      let audio = audioResponse;
      let request_id = requestId;
      // console.log(request_id);
      try {
        const response = await fetch("https://34.41.231.47:8000/get_video", {
          method: "POST",
          headers: {
            "Content-Type": "application/json",
          },
          body: JSON.stringify({ audio, request_id }), // Send the summary as the request
        });
        if (response.ok) {
          const data = await response.json(); // Assuming the response is text
          // console.log(data);
          // console.log(data.video);
          setVideoResponse(data.video);
          // console.log(videoResponse);
        } else {
          console.error("Failed to fetch video");
        }
      } catch (error) {
        console.error("Error:", error);
      } finally {
        setLoading(false);
      }
    }
  };

  useEffect(() => {
    if (audioResponse) {
      try {
        const audioDataUri = `data:audio/wav;base64,${audioResponse}`;
        setAudioUrl(audioDataUri);
      } catch (error) {
        console.error("Error converting audio data to data URI:", error);
      }
    }
  }, [audioResponse]);

  useEffect(() => {
    console.log("Updated videoResponse:", videoResponse);
  }, [videoResponse]);

  //   const audioBlob = new Blob([audioResponse], { type: "audio/wav" });
  //   const audioUrl = URL.createObjectURL(audioBlob);

  // console.log("Video: ", videoResponse);
  //   let x = audioUrl;
  // console.log(audioUrl);

  useEffect(() => {
    // Start the timer when loading is true
    let interval;
    if (loading) {
      interval = setInterval(() => {
        setTimer((prevTimer) => prevTimer + 1);
      }, 1000); // Update the timer every 1 second
    } else {
      clearInterval(interval); // Clear the interval when loading is false
    }

    return () => {
      clearInterval(interval); // Cleanup the interval on unmount
    };
  }, [loading]);

  function formatTime(seconds) {
    const minutes = Math.floor(seconds / 60);
    const remainingSeconds = seconds % 60;
    const formattedMinutes = minutes < 10 ? `0${minutes}` : minutes;
    const formattedSeconds =
      remainingSeconds < 10 ? `0${remainingSeconds}` : remainingSeconds;
    return `${formattedMinutes}:${formattedSeconds}`;
  }

  // let videoResponse1 =
  //   "https://storage.googleapis.com/wav2lip-niveus/output/123/result.mp4";

  const downloadVideo = () => {
    if (videoResponse) {
      // Downloads the file
      const link = document.createElement("a");
      link.download = "News.mp4";
      const blob = new Blob([videoResponse], { type: "video/mp4" });
      console.log(blob);
      link.href = URL.createObjectURL(blob);
      link.click();
      URL.revokeObjectURL(link.href);
    }
  };

  const handleTryNew = () => {
    window.scrollTo({
      top: 0,
      behavior: "smooth", // Use smooth scrolling behavior
    });

    // Reload the page after a short delay (e.g., 500 milliseconds)
    setTimeout(() => {
      window.location.reload();
    }, 600);
  };

  return (
    <div className="container">
      <div className="audio-container">
        <h2 className="sub-heading">Audio</h2>

        {audioUrl ? (
          <div>
            <audio controls name="media">
              <source src={audioUrl} type="audio/wav" />
            </audio>
          </div>
        ) : (
          <div>
            <audio controls name="media">
              {/* <source type="audio/wav" /> */}
            </audio>
          </div>
        )}
        {loading ? (
          <>
            <button className="video-load-btn">Generating...</button>
            <p className="get-video-msg">
              Please hold on!! Video generation will take around 2 to 3 minutes.
              Timer: {formatTime(timer)}
            </p>
            {/* <p className="timer">Timer: {formatTime(timer)}</p> */}
          </>
        ) : (
          <button className="button" onClick={handleGetVideo}>
            Get Video
          </button>
        )}
      </div>

      {/* <Video videoResponse={videoResponse} requestId={requestId} /> */}
      {/* Display the video response */}
      <div className="video-container">
        <h2 className="sub-heading">Video</h2>
        {/* <div className="video-container">{videoResponse}</div>{" "} */}
        {loading ? (
          <div className="loading-container">
            <Loading />
          </div>
        ) : (
          <>
            <div>
              <video
                // width="320"
                height="425"
                controls
                key={videoResponse}
              >
                <source src={videoResponse} type="video/mp4" />
              </video>
            </div>
            <div>
              <button className="button" onClick={downloadVideo}>
                Download
              </button>
              <button className="button" onClick={handleTryNew}>
                Retry
              </button>
            </div>
          </>
        )}
        {/* <div>
          <video
            // width="320"
            height="425"
            controls
            key={videoResponse}
          >
            <source src={videoResponse} type="video/mp4" />
          </video>
        </div>
        <div>
          <button className="button" onClick={downloadVideo}>
            Download
          </button>
        </div> */}
        {/* https://storage.googleapis.com/wav2lip-niveus/output/123/result.mp4 */}
        {/* Display the video response */}
      </div>
    </div>
  );
}

export default Audio;
