import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import mongoose, { HydratedDocument, Types } from 'mongoose';

export type UsersDocument = HydratedDocument<Users>;

@Schema()
export class Users {

    @Prop([{
        type: mongoose.Schema.Types.ObjectId, ref: "Transactions", 
    }])
    transactions: Types.ObjectId[];

    @Prop({
        required: true
    })
    name: string;

}

export const UserSchema = SchemaFactory.createForClass(Users)