import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import mongoose, { HydratedDocument } from 'mongoose';
import { Users } from './user.model';

export type TransactionDocument = HydratedDocument<Transactions>;

@Schema()
export class Transactions {
  @Prop({
    type: mongoose.Schema.Types.ObjectId, ref: "Users"
  })
  user : Users;

  @Prop({
    required: true
  })
  item: string;

  @Prop({
    required: true
  })
  date: number;

  @Prop({
    required: true
  })
  amount: number;  
}

export const TransactionSchema = SchemaFactory.createForClass(Transactions)