import { Injectable, InternalServerErrorException } from '@nestjs/common';
import { Storage } from '@google-cloud/storage'
import { join } from 'path';
import { ConfigService } from '@nestjs/config';

@Injectable()
export class FileService {
    constructor(private configService: ConfigService) { }

    async upload(file: Express.Multer.File) {
        // console.log(join(__dirname, `../${this.configService.get("GCP_BUCKET_CONFIG")}.json`))
        const storage = new Storage({
            keyFilename: join(__dirname, `../${this.configService.get("GCP_BUCKET_CONFIG")}.json`),
        });

        if(!storage) {
            throw new InternalServerErrorException({
                statusCode: -1,
                error: "storage Iniitialize failed"
            })
        }

        const bucketName = 'goodbucketname'
        const bucket = storage.bucket(bucketName)

        // Sending the upload request
        const fileStream = bucket.file(file.originalname).createWriteStream();
        
        fileStream.end(file.buffer)
        const result = () => {
            return new Promise((res, rej) => {
                fileStream.on("finish", () => {
                    res("Done Processing image")
                })
        
                fileStream.on("error", (error) => {
                    console.log(error)
                    rej(error.message)
                })        
            })
        }

        try {
             await result();
            return "File Uploaded"
        } catch (error) {
            throw new InternalServerErrorException({
                statusCode: -1,
                error: JSON.stringify(error?.stack ?? error)
            })
        }
        

    }
}
