import { Inject, Injectable } from '@nestjs/common';
import { InjectModel } from '@nestjs/mongoose';
import { Users } from './models/user.model';
import mongoose, { Model } from 'mongoose';
import { User, UserTransaction, GetUserTransaction } from './dtos/user.dto';
import { Transactions } from './models/transaction.model';
import { CACHE_MANAGER } from '@nestjs/cache-manager';
import { Cache } from 'cache-manager';

@Injectable()
export class AppService {

  constructor(@InjectModel(Users.name) private userModel: Model<Users>,
    @InjectModel(Transactions.name) private transactionModel: Model<Transactions>,
    @Inject(CACHE_MANAGER) private cacheManager: Cache
  ) { }

  getHello() {
    return "Hello World!"
  }


  async createUser(payload: User) {
    const user = await this.userModel.create(payload)
    await user.save();
    return `user saved`
  }

  async setUserTransaction(payload: UserTransaction) {
    const transaction = await this.transactionModel.create(payload);
    await transaction.save();

    const user = await this.userModel.findById(payload.id);
    console.log(user)
    user.transactions.push(transaction._id);
    user.save();

    return "transaction saved"
  }

  async getUserTransactions(payload: GetUserTransaction) {
    const PAGE_LIMIT = payload.limit ?? 5;
    const PAGE_NO = (payload.pageNo ?? 1);

    const memCheck = await this.cacheManager.get(JSON.stringify(payload));
    if (memCheck) {
      return memCheck;
    }

    let match: any = {};
    if (payload.date) {
      match.date = payload.date
    }

    if (payload.amount) {
      match.amount = payload.amount
    }

    let userDetails = (await this.userModel.findById(payload.id)).populate({
      path: "transactions",
      match: match,
      options: {
        skip: (PAGE_NO - 1) * PAGE_LIMIT,
        limit: PAGE_LIMIT
      }
    });

    // let userDetails = await this.userModel.aggregate([
    //   {
    //     $match: {
    //       _id: new mongoose.Types.ObjectId(payload.id)
    //     },
    //   },
    //   {
    //     $unwind: "$transactions"
    //   },
    //   {
    //     $lookup: {
    //       from: "transactions",
    //       localField: "transactions",
    //       foreignField: "_id",
    //       as: "transactions",
    //     }
    //   },

    //   {
    //     $skip: (PAGE_NO - 1) * PAGE_LIMIT
    //   },
    //   {
    //     $limit: PAGE_LIMIT
    //   },
    //   {
    //     $group: {
    //       _id: "$_id",
    //       transactionsList: {
    //         $push: {
    //           items: {
    //             $first: "$transactions"
    //           }
    //         }
    //       }
    //     }
    //   }
    // ])

    await this.cacheManager.set(JSON.stringify(payload), userDetails, { ttl: 5000 } as any);
    return userDetails;
  }
}
