import { Module } from '@nestjs/common';
import { AppController } from './app.controller';
import { AppService } from './app.service';
import { ConfigModule } from '@nestjs/config';
import { MongooseModule } from '@nestjs/mongoose';
import { Users, UserSchema } from './models/user.model';
import { Transactions, TransactionSchema } from './models/transaction.model';
import { CacheModule } from '@nestjs/cache-manager';
import { RedisOptions } from './constants';
import { FileService } from './file.service';

@Module({
  imports: [
    ConfigModule.forRoot(),
    CacheModule.registerAsync(RedisOptions),
    // CacheModule.register(),
    MongooseModule.forRoot(process.env.DB_URL),
    MongooseModule.forFeature([
      { name: Users.name, schema: UserSchema },
      { name: Transactions.name, schema: TransactionSchema },
    ])
  ],
  controllers: [AppController],
  providers: [AppService, FileService],
})
export class AppModule {}
