import { Body, Controller, Get, Post, UploadedFile, UseInterceptors } from '@nestjs/common';
import { AppService } from './app.service';
import { User, GetUserTransaction } from './dtos/user.dto';
import { FileInterceptor } from '@nestjs/platform-express';
import { FileService } from './file.service';

@Controller()
export class AppController {
  constructor(private readonly appService: AppService,
    private readonly fileService: FileService
  ) { }

  @Get()
  getHello() {
    return this.appService.getHello();
  }


  @Post('/createUser')
  async createUser(@Body() payload: User) {
    return await this.appService.createUser(payload)
  }

  @Post('/setUserTransaction')
  async setUserTransaction(@Body() payload) {
    return await this.appService.setUserTransaction(payload)
  }

  @Post('/getUserTransaction')
  async getUserTransaction(@Body() payload: GetUserTransaction) {
    return await this.appService.getUserTransactions(payload)
  }


  @Post('/upload')
  @UseInterceptors(FileInterceptor('file'))
  async uploadFile(@UploadedFile() file: Express.Multer.File) {
    return await this.fileService.upload(file)
  }

}
