import { Test, TestingModule } from '@nestjs/testing';
import { AppController } from './app.controller';
import { AppService } from './app.service';
import { FileService } from './file.service';

jest.mock('./app.service')
jest.mock('./file.service')

describe('AppController', () => {
  let appController: AppController;
  let appService: AppService;
  let fileService: FileService;

  beforeEach(async () => {
    const app: TestingModule = await Test.createTestingModule({
      controllers: [AppController],
      providers: [AppService, FileService],
    }).compile();

    appService = app.get(AppService);
    fileService = app.get(FileService);
    appController = app.get<AppController>(AppController);
  });

  describe('root', () => {
    it('should return "Hello World!"', () => {
      expect(appController.getHello()).toBe('Hello World!');
    });
  });


  describe("createUser", () => {
    describe("when user is called", () => {
      let user = ""
      let payload = {
        name: "test"
      }

      beforeEach(async () => {
        user = await appController.createUser(payload)
      })

      test("then it should call UserService", () => {
        expect(appService.createUser).toHaveBeenCalledWith(payload)
      })

      test("then it should return user saved", () => {
        expect(user).toBe("user saved")
      })
    })
  })

  describe("setTransactions", () => {
    describe("when setTransactions is called", () => {
      let user = ""
      let payload = {
        "id": "659c440f5605c4ccf2eeaacb",
        "item": "item",
        "date": "1704725146285",
        "amount": 500
      }

      beforeEach(async () => {
        user = await appController.setUserTransaction(payload)
      })

      test("then it should call UserService", () => {
        expect(appService.setUserTransaction).toHaveBeenCalledWith(payload)
      })

      test("then it should return user saved", () => {
        expect(user).toBe("transaction saved")
      })
    })
  })

  describe("getTransactions", () => {
    describe("when setTransactions is called", () => {
      let user;
      let payload = {
        "id": "659c43ef5605c4ccf2eeaab9",
        "pageNo": 1,
        "limit": 10,
        "amount": 1700
      } as any;

      let returnData = {
        id: "659c43ef5605c4ccf2eeaab9",
        transactions: [
          {
            name: "test",
            amount: 1299,
            date: 1704725146285
          }
        ]
      }


      beforeEach(async () => {
        user = await appController.getUserTransaction(payload)
      })

      test("then it should call UserService", () => {
        expect(appService.getUserTransactions).toHaveBeenCalledWith(payload)
      })

      test("then it should return user saved", () => {
        expect(user).toEqual(returnData)
      })
    })
  })

});
