require('dotenv').config();
const express = require('express');
const bodyParser = require('body-parser');
const swaggerUi = require('swagger-ui-express');
const YAML = require('yamljs');
const connectDB = require('./db');

const app = express();
app.use(bodyParser.json());
const apiBaseRouter = require('./api/apiBaseRouter');

// Connect to MongoDB
connectDB();

// Serve Swagger API documentation
const swaggerDocument = YAML.load('./swagger.yaml');
app.use('/api-docs', swaggerUi.serve, swaggerUi.setup(swaggerDocument));

// API base URL
app.use(apiBaseRouter);

// Start the server
const PORT = process.env.SERVICE_PORT || 5000;
const BASE_URL = process.env.SERVICE_BASE_URL || `http://localhost:${PORT}`;

app.listen(PORT, () => {
    console.log(`Server is running on port ${PORT}`);
    console.log(`Swagger UI available at ${BASE_URL}/api-docs`);
});
