// const logger = require('utils/logger');

const Widget = require("../models/widget");
const Template = require("../models/template")


const updateAndMapWidget = async (page,widgetId,position, startTime, endTime) => {
  try {
    const template = await Template.findOne({ name: page });
    if (!template) {
      return { status: 404,  error: 'template not found' };
    }
    console.log(page,widgetId,position, startTime, endTime)
    const widgetIndex = template.widgets.findIndex(w => w.widgetId.toString() === widgetId);
    
    if (widgetIndex !== -1) {
      template.widgets[widgetIndex] = {
        ...template.widgets[widgetIndex], 
        position,                         
        startTime,                       
        endTime                          
      };
    } else {
      template.widgets.push({
        widgetId: widgetId,  
        position,            
        startTime,           
        endTime              
      });
    }

    await template.save();
    return { status: 200, widgetId: widgetId, page: page };
  } catch (error) {
    throw error
  }

};

const createTemplate = async (name, desc, platform, widgets, hashId) => {
  try {
    const newTemplate = new Template({
      name,
      desc,
      platform,
      widgets,
      hashId
    });

    // Save the template to the database
    await newTemplate.save();
    return { status: 201,  message: 'Template created successfully', id: newTemplate._id };
  } catch (error) {
    throw error
  }

};

const getParticularTemplate = async (page,platform) => {
  try {
    const template = await Template.findOne({ name: page,platform}).populate('widgets.widgetId');
    if (!template) {
      return { status: 404,  message: 'Template not found'};
    }
    return template;
  } catch (error) {
    throw error
  }

};


module.exports = {
  updateAndMapWidget,
  createTemplate,
  getParticularTemplate
};