const mongoose = require('mongoose');
const Schema = mongoose.Schema;

// Define schema for widgets within a template or page
const WidgetRefSchema = new Schema({
    widgetId: { type: mongoose.Schema.Types.ObjectId, ref: 'Widget', required: true }, // Reference to the Widget model
    position: { type: Number, required: true },
    startTime: { type: Date, required: true },
    endTime: { type: Date, required: true }
});

// Define main Template schema
const TemplateSchema = new Schema({
    name: { type: String, required: true },
    desc: { type: String },
    platform: { 
        type: String, 
        enum: ['web', 'mobile', 'both'], 
        required: true 
      },
    widgets: [WidgetRefSchema],
    hashId: { type: String, unique: true, required: true },
    createdAt: { type: Date, default: Date.now },
    updatedAt: { type: Date, default: Date.now }
});

module.exports = mongoose.model('Template', TemplateSchema);
