// server.js
const express = require('express');
const bodyParser = require('body-parser');
const swaggerUi = require('swagger-ui-express');
const YAML = require('yamljs');
const connectDB = require('./db');

const app = express();
app.use(bodyParser.json());
const apiBaseRouter = require('./api/apiBaseRouter');

const baseURL = '/api-service';

// Connect to MongoDB
connectDB();

// Serve Swagger API documentation
const swaggerDocument = YAML.load('./swagger.yaml');
app.use('/api-docs', swaggerUi.serve, swaggerUi.setup(swaggerDocument));

// API base URL
app.use(apiBaseRouter);


// Start the server
const PORT = process.env.PORT || 5000;
app.listen(PORT, () => {
    console.log(`Server is running on port ${PORT}`);
    console.log(`Swagger UI available at http://localhost:${PORT}/api-docs`);
});
