const mongoose = require('mongoose');
const Schema = mongoose.Schema;

// Define schema for the button data
const ButtonDataSchema = new Schema({
    url: { type: String, required: true },
    title: { type: String, required: true }
});

// Define schema for banner data
const BannerDataSchema = new Schema({
    imageName: { type: String, default: '' },
    headingText: { type: String, required: true },
    subHeadingText: { type: String, required: true },
    landingUrl: { type: String, required: true },
    timerPosition: { type: String, default: null },
    timerColor: { type: String, default: null }
});

// Define schema for list items
const ListItemSchema = new Schema({
    bannerData: { type: BannerDataSchema, required: true },
    display_order: { type: Number, required: true },
    dimension: {
        length: { type: Number, required: true },
        breadth: { type: Number, required: true }
    },
    banner_title: { type: String, required: true }
});

// Define main Widget schema
const WidgetSchema = new Schema({
    title: { type: String, required: true },
    layout: { type: String, required: true },
    priority: { type: Number, required: true },
    enable: { type: Boolean, default: true },
    buttonData: [ButtonDataSchema],
    sectionHeadingText: { type: String, required: true },
    apiUrl: { type: String, required: true },
    list: [ListItemSchema],
    createdAt: { type: Date, default: Date.now },
    updatedAt: { type: Date, default: Date.now }
});

module.exports = mongoose.model('Widget', WidgetSchema);
