/**
 @file        <file name>
 @description  <description>
 @author      <Your Name>
 @created     <YYYY-MM-DD>
**/

import {
  seedModel,
  seedWithMultipleParents,
  ForeignKeyConfig,
} from 'nest-common-utilities';
import { PrismaService } from './prisma/prisma.service';

// Instantiate Prisma service
const prisma = new PrismaService();

const userData = [
  {
    name: 'Roshan',
    email: 'roshanadmin@niveus.com',
    hashemail: 'roshanadmin@niveus.com',
    password: '123456',
    role: 'admin',
  },
  {
    name: 'Roshanuser',
    email: 'roshanuser@niveus.com',
    hashemail: 'roshanuser@niveus.com',
    password: '123456',
    role: 'user',
  },
  {
    name: 'Prathviraj',
    email: 'prathvirajadmin@niveus.com',
    hashemail: 'prathvirajadmin@niveus.com',
    password: '123456',
    role: 'admin',
  },
  {
    name: 'Prathvirajuser',
    email: 'prathvirajuser@niveus.com',
    hashemail: 'prathvirajuser@niveus.com',
    password: '123456',
    role: 'user',
  },
];

const hospitalSpecialtyMasterData: Array<{
  name: string;
  userName: string;
  created_by?: string;
  updated_by?: string;
}> = [
  {
    name: 'Super-Speciality',
    userName: 'Prathviraj',
  },
  {
    name: 'Multi-Speciality',
    userName: 'Prathviraj',
  },
  {
    name: 'Cancer Hospital',
    userName: 'Prathviraj',
  },
  {
    name: 'Maternity',
    userName: 'Prathviraj',
  },
  {
    name: 'Eye Hospital',
    userName: 'Prathviraj',
  },
  {
    name: 'ENT',
    userName: 'Prathviraj',
  },
  {
    name: 'Orthopedic',
    userName: 'Prathviraj',
  },
  {
    name: 'Nursing Home',
    userName: 'Prathviraj',
  },
  {
    name: 'Ayurvedic',
    userName: 'Prathviraj',
  },
  {
    name: 'Dental',
    userName: 'Prathviraj',
  },
  {
    name: 'Childcare/Pediatric',
    userName: 'Prathviraj',
  },
  {
    name: 'Daycare',
    userName: 'Prathviraj',
  },
  {
    name: 'Urology',
    userName: 'Prathviraj',
  },
  {
    name: 'General Hospital',
    userName: 'Prathviraj',
  },
  {
    name: 'Surgical',
    userName: 'Prathviraj',
  },
  {
    name: 'Secondary',
    userName: 'Prathviraj',
  },
  {
    name: 'Nurology',
    userName: 'Prathviraj',
  },
  {
    name: 'BURNS',
    userName: 'Prathviraj',
  },
  {
    name: 'COVID Temporary Hospital',
    userName: 'Prathviraj',
  },
  {
    name: 'Cardiac',
    userName: 'Prathviraj',
  },
];
const hospitalSpecialtyMasterDataForeignKeys: ForeignKeyConfig<
  (typeof hospitalSpecialtyMasterData)[0]
>[] = [
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'created_by',
  },
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'updated_by',
  },
];

const hospitalTypeMasterData: Array<{
  name: string;
  userName: string;
  created_by?: string;
  updated_by?: string;
}> = [
  {
    name: 'Government',
    userName: 'Prathviraj',
  },
  {
    name: 'Corporate',
    userName: 'Prathviraj',
  },
  {
    name: 'Private',
    userName: 'Prathviraj',
  },
  {
    name: 'Mission',
    userName: 'Prathviraj',
  },
  {
    name: 'Trust',
    userName: 'Prathviraj',
  },
  {
    name: 'Memorial',
    userName: 'Prathviraj',
  },
  {
    name: 'Individual',
    userName: 'Prathviraj',
  },
  {
    name: 'Research Institute',
    userName: 'Prathviraj',
  },
];
const hospitalTypeMasterDataForeignKeys: ForeignKeyConfig<
  (typeof hospitalTypeMasterData)[0]
>[] = [
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'created_by',
  },
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'updated_by',
  },
];

const hospitalCareMasterData: Array<{
  name: string;
  userName: string;
  created_by?: string;
  updated_by?: string;
}> = [
  {
    name: 'Primary',
    userName: 'Prathviraj',
  },
  {
    name: 'Secondary',
    userName: 'Prathviraj',
  },
  {
    name: 'Tertiary',
    userName: 'Prathviraj',
  },
  {
    name: 'Tertiary Plus',
    userName: 'Prathviraj',
  },
];
const hospitalCareMasterDataForeignKeys: ForeignKeyConfig<
  (typeof hospitalCareMasterData)[0]
>[] = [
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'created_by',
  },
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'updated_by',
  },
];

const hospitalDiscountMasterData = [
  { name: 'ICU Charges', is_active: true },
  { name: 'Implant', is_active: true },
  { name: 'Investigation Charges', is_active: true },
  { name: 'Medical package', is_active: true },
  { name: 'Medicine & Consumables charges', is_active: true },
  { name: 'Miscellaneous charges', is_active: true },
  { name: 'OT Charges', is_active: true },
  { name: 'Other Expenses', is_active: true },
  { name: 'Package Charges', is_active: true },
  { name: 'Pharmacy Bill Charge', is_active: true },
  { name: 'Pharmacy Charges', is_active: true },
  { name: 'Professional Fees Charges', is_active: true },
];

const hospitalRoomTypesData: Array<{
  name: string;
  userName: string;
  created_by?: string;
  updated_by?: string;
}> = [
  {
    name: 'ROOM',
    userName: 'Prathviraj',
  },
  {
    name: 'ICU',
    userName: 'Prathviraj',
  },
];
const hospitalRoomTypesDataForeignKeys: ForeignKeyConfig<
  (typeof hospitalRoomTypesData)[0]
>[] = [
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'created_by',
  },
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'updated_by',
  },
];

const hospitalRoomCategoriesData: Array<{
  name: string;
  userName: string;
  roomName: string;
  room_id?: string;
  created_by?: string;
  updated_by?: string;
}> = [
  {
    name: 'General',
    roomName: 'ROOM',
    userName: 'Prathviraj',
  },
  {
    name: 'Semi-Private',
    roomName: 'ROOM',
    userName: 'Prathviraj',
  },
  {
    name: 'Private',
    roomName: 'ROOM',
    userName: 'Prathviraj',
  },
  {
    name: 'Deluxe',
    roomName: 'ROOM',
    userName: 'Prathviraj',
  },
  {
    name: 'Super Deluxe',
    roomName: 'ROOM',
    userName: 'Prathviraj',
  },
  {
    name: 'Suite',
    roomName: 'ROOM',
    userName: 'Prathviraj',
  },
  {
    name: 'ICU',
    roomName: 'ICU',
    userName: 'Prathviraj',
  },
  {
    name: 'NICU',
    roomName: 'ICU',
    userName: 'Prathviraj',
  },
  {
    name: 'Private - AC',
    roomName: 'ROOM',
    userName: 'Prathviraj',
  },
  {
    name: 'Private - DAC',
    roomName: 'ROOM',
    userName: 'Prathviraj',
  },
  {
    name: 'HDUI - High Dependency Unit',
    roomName: 'ICU',
    userName: 'Prathviraj',
  },
  {
    name: 'CCU - Cardiac Care Unit',
    roomName: 'ICU',
    userName: 'Prathviraj',
  },
  {
    name: 'Day Care',
    roomName: 'ROOM',
    userName: 'Prathviraj',
  },
  {
    name: 'Isolation Room',
    roomName: 'ROOM',
    userName: 'Prathviraj',
  },
  {
    name: 'Triple Share',
    roomName: 'ROOM',
    userName: 'Prathviraj',
  },
  {
    name: 'Labour Room',
    roomName: 'ROOM',
    userName: 'Prathviraj',
  },
  {
    name: 'President Room',
    roomName: 'ROOM',
    userName: 'Prathviraj',
  },
  {
    name: 'DIALYSIS',
    roomName: 'ICU',
    userName: 'Prathviraj',
  },
];
const hospitalRoomCategoriesDataForeignKeys: ForeignKeyConfig<
  (typeof hospitalRoomCategoriesData)[0]
>[] = [
  {
    parentModel: 'hospital_room_types',
    parentLookupKey: 'name',
    childReferenceKey: 'roomName',
    childForeignKeyField: 'room_id',
  },
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'created_by',
  },
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'updated_by',
  },
];

const stateMasterData: Array<{
  name: string;
  userName: string;
  state_hcs_id: number;
  created_by?: string;
  updated_by?: string;
}> = [
  {
    name: 'Maharashtra',
    state_hcs_id: 1,
    userName: 'Prathviraj',
  },
  {
    name: 'Karnataka',
    state_hcs_id: 2,
    userName: 'Prathviraj',
  },
];
const stateMasterDataForeignKeys: ForeignKeyConfig<
  (typeof stateMasterData)[0]
>[] = [
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'created_by',
  },
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'updated_by',
  },
];

const cityMasterData: Array<{
  name: string;
  userName: string;
  stateName: string;
  city_hcs_id: number;
  state_hcs_id: number;
  state_id?: string;
  created_by?: string;
  updated_by?: string;
}> = [
  {
    name: 'Mumbai',
    stateName: 'Maharashtra',
    city_hcs_id: 1,
    state_hcs_id: 1,
    userName: 'Prathviraj',
  },
  {
    name: 'Pune',
    stateName: 'Maharashtra',
    city_hcs_id: 2,
    state_hcs_id: 1,
    userName: 'Prathviraj',
  },
  {
    name: 'Latur',
    stateName: 'Maharashtra',
    city_hcs_id: 3,
    state_hcs_id: 1,
    userName: 'Prathviraj',
  },
  {
    name: 'Dhule',
    stateName: 'Maharashtra',
    city_hcs_id: 4,
    state_hcs_id: 1,
    userName: 'Prathviraj',
  },
  {
    name: 'Solapur',
    stateName: 'Maharashtra',
    city_hcs_id: 5,
    state_hcs_id: 1,
    userName: 'Prathviraj',
  },
  {
    name: 'Bangalore',
    stateName: 'Karnataka',
    city_hcs_id: 6,
    state_hcs_id: 2,
    userName: 'Prathviraj',
  },
  {
    name: 'Hubbli',
    stateName: 'Karnataka',
    city_hcs_id: 7,
    state_hcs_id: 2,
    userName: 'Prathviraj',
  },
  {
    name: 'Mangalore',
    stateName: 'Karnataka',
    city_hcs_id: 8,
    state_hcs_id: 2,
    userName: 'Prathviraj',
  },
  {
    name: 'Udupi',
    stateName: 'Karnataka',
    city_hcs_id: 9,
    state_hcs_id: 2,
    userName: 'Prathviraj',
  },
  {
    name: 'Bidar',
    stateName: 'Karnataka',
    city_hcs_id: 10,
    state_hcs_id: 2,
    userName: 'Prathviraj',
  },
];
const cityMasterDataForeignKeys: ForeignKeyConfig<
  (typeof cityMasterData)[0]
>[] = [
  {
    parentModel: 'state_master',
    parentLookupKey: 'name',
    childReferenceKey: 'stateName',
    childForeignKeyField: 'state_id',
  },
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'created_by',
  },
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'updated_by',
  },
];

const districtMasterData: Array<{
  name: string;
  userName: string;
  stateName: string;
  district_hcs_id: number;
  state_hcs_id: number;
  state_id?: string;
  created_by?: string;
  updated_by?: string;
}> = [
  {
    name: 'Mumbai',
    stateName: 'Maharashtra',
    district_hcs_id: 1,
    state_hcs_id: 1,
    userName: 'Prathviraj',
  },
];
const districtMasterDataForeignKeys: ForeignKeyConfig<
  (typeof districtMasterData)[0]
>[] = [
  {
    parentModel: 'state_master',
    parentLookupKey: 'name',
    childReferenceKey: 'stateName',
    childForeignKeyField: 'state_id',
  },
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'created_by',
  },
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'updated_by',
  },
];

const regionMasterData = [
  { name: 'East', is_active: true },
  { name: 'West', is_active: true },
  { name: 'North', is_active: true },
  { name: 'South', is_active: true },
];

const pincodeData: Array<{
  name: string;
  stateName: string;
  cityName: string;
  city_hcs_id: number;
  state_hcs_id: number;
  pincode_hcs_id: number;
  userName: string;
  // Add these missing foreign key fields:
  state_id?: string;
  city_id?: string;
  created_by?: string;
  updated_by?: string;
}> = [
  {
    name: '400078',
    cityName: 'Mumbai',
    city_hcs_id: 1,
    state_hcs_id: 1,
    pincode_hcs_id: 1,
    stateName: 'Maharashtra',
    userName: 'Prathviraj',
  },
  {
    name: '400079',
    cityName: 'Mumbai',
    city_hcs_id: 1,
    state_hcs_id: 1,
    pincode_hcs_id: 1,
    stateName: 'Maharashtra',
    userName: 'Prathviraj',
  },
  {
    name: '400033',
    cityName: 'Latur',
    city_hcs_id: 3,
    state_hcs_id: 1,
    pincode_hcs_id: 1,
    stateName: 'Maharashtra',
    userName: 'Prathviraj',
  },
  {
    name: '400604',
    cityName: 'Solapur',
    city_hcs_id: 5,
    state_hcs_id: 1,
    pincode_hcs_id: 1,
    stateName: 'Maharashtra',
    userName: 'Prathviraj',
  },
  {
    name: '400011',
    cityName: 'Mangalore',
    city_hcs_id: 8,
    state_hcs_id: 2,
    pincode_hcs_id: 1,
    stateName: 'Karnataka',
    userName: 'Prathviraj',
  },
  {
    name: '400012',
    cityName: 'Mangalore',
    city_hcs_id: 8,
    state_hcs_id: 2,
    pincode_hcs_id: 1,
    stateName: 'Karnataka',
    userName: 'Prathviraj',
  },
  {
    name: '400023',
    cityName: 'Udupi',
    city_hcs_id: 9,
    state_hcs_id: 2,
    pincode_hcs_id: 1,
    stateName: 'Karnataka',
    userName: 'Prathviraj',
  },
  {
    name: '400644',
    cityName: 'Hubbli',
    city_hcs_id: 7,
    state_hcs_id: 2,
    pincode_hcs_id: 1,
    stateName: 'Karnataka',
    userName: 'Prathviraj',
  },
];

const pincodeForeignKeys: ForeignKeyConfig<(typeof pincodeData)[0]>[] = [
  {
    parentModel: 'state_master',
    parentLookupKey: 'name',
    childReferenceKey: 'stateName',
    childForeignKeyField: 'state_id',
  },
  {
    parentModel: 'city_master',
    parentLookupKey: 'name',
    childReferenceKey: 'cityName',
    childForeignKeyField: 'city_id',
  },
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'created_by',
  },
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'updated_by',
  },
];

const hospitalCorporateData: Array<{
  name: string;
  address: string;
  locality: string;
  stateName: string;
  cityName: string;
  district_id: string;
  regionName: string;
  pincodeName: string;
  email_id: string;
  website: string;
  contact_hash: string;
  latitude: number;
  longitude: number;
  contact_no: string;
  userName: string;
  // Add these missing foreign key fields:
  state_id?: string;
  city_id?: string;
  region_id?: string;
  pincode_id?: string;
  created_by?: string;
  updated_by?: string;
}> = [
  {
    name: 'Apollo Hospitals',
    address: '123 Health Street',
    locality: 'Greenfield',
    stateName: 'Maharashtra',
    cityName: 'Mumbai',
    district_id: 'District-1',
    regionName: 'East',
    pincodeName: '400078',
    email_id: 'contact@apollo.com',
    website: 'https://apollo.com',
    contact_hash: 'hash-apollo',
    latitude: 12.971598,
    longitude: 77.594566,
    contact_no: '+91-9000000001',
    userName: 'Prathviraj',
  },
  {
    name: 'Fortis Hospital',
    address: '456 Care Avenue',
    locality: 'Bluefield',
    stateName: 'Maharashtra',
    cityName: 'Mumbai',
    district_id: 'District-2',
    regionName: 'East',
    pincodeName: '400078',
    email_id: 'info@fortis.com',
    website: 'https://fortis.com',
    contact_hash: 'hash-fortis',
    latitude: 28.613939,
    longitude: 77.209023,
    contact_no: '+91-9000000002',
    userName: 'Prathviraj',
  },
  {
    name: 'Max Healthcare',
    address: '789 Wellness Road',
    locality: 'Sunview',
    stateName: 'Maharashtra',
    cityName: 'Mumbai',
    district_id: 'District-3',
    regionName: 'East',
    pincodeName: '400078',
    email_id: 'contact@max.com',
    website: 'https://maxhealthcare.in',
    contact_hash: 'hash-max',
    latitude: 19.07609,
    longitude: 72.877426,
    contact_no: '+91-9000000003',
    userName: 'Prathviraj',
  },
  {
    name: 'Manipal Hospitals',
    address: '321 Care Lane',
    locality: 'Eastfield',
    stateName: 'Maharashtra',
    cityName: 'Mumbai',
    district_id: 'District-4',
    regionName: 'East',
    pincodeName: '400078',
    email_id: 'info@manipal.com',
    website: 'https://manipalhospitals.com',
    contact_hash: 'hash-manipal',
    latitude: 13.08268,
    longitude: 80.270721,
    contact_no: '+91-9000000004',
    userName: 'Prathviraj',
  },
  {
    name: 'Narayana Health',
    address: '555 Heartway',
    locality: 'Westend',
    stateName: 'Maharashtra',
    cityName: 'Mumbai',
    district_id: 'District-5',
    regionName: 'East',
    pincodeName: '400078',
    email_id: 'care@narayana.com',
    website: 'https://narayanahealth.org',
    contact_hash: 'hash-narayana',
    latitude: 17.385044,
    longitude: 78.486671,
    contact_no: '+91-9000000005',
    userName: 'Prathviraj',
  },
  {
    name: 'AIIMS Delhi',
    address: 'Aurobindo Marg',
    locality: 'Ansari Nagar',
    stateName: 'Maharashtra',
    cityName: 'Mumbai',
    district_id: 'District-6',
    regionName: 'East',
    pincodeName: '400078',
    email_id: 'aiims@aiims.edu',
    website: 'https://aiims.edu',
    contact_hash: 'hash-aiims',
    latitude: 28.5672,
    longitude: 77.21,
    contact_no: '+91-9000000006',
    userName: 'Prathviraj',
  },
  {
    name: 'Columbia Asia',
    address: '789 Global Blvd',
    locality: 'Tech Park',
    stateName: 'Maharashtra',
    cityName: 'Mumbai',
    district_id: 'District-7',
    regionName: 'East',
    pincodeName: '400078',
    email_id: 'hello@columbiaasia.com',
    website: 'https://columbiaasia.com',
    contact_hash: 'hash-columbia',
    latitude: 13.035,
    longitude: 77.597,
    contact_no: '+91-9000000007',
    userName: 'Prathviraj',
  },
  {
    name: 'Care Hospitals',
    address: '12 Health Bay',
    locality: 'River View',
    stateName: 'Maharashtra',
    cityName: 'Mumbai',
    district_id: 'District-8',
    regionName: 'East',
    pincodeName: '400078',
    email_id: 'care@carehospitals.com',
    website: 'https://carehospitals.com',
    contact_hash: 'hash-care',
    latitude: 18.52043,
    longitude: 73.856743,
    contact_no: '+91-9000000008',
    userName: 'Prathviraj',
  },
  {
    name: 'KIMS Hospitals',
    address: '33 Life Drive',
    locality: 'Central Zone',
    stateName: 'Maharashtra',
    cityName: 'Mumbai',
    district_id: 'District-9',
    regionName: 'East',
    pincodeName: '400078',
    email_id: 'info@kimshospitals.com',
    website: 'https://kimshospitals.com',
    contact_hash: 'hash-kims',
    latitude: 16.506174,
    longitude: 80.648015,
    contact_no: '+91-9000000009',
    userName: 'Prathviraj',
  },
  {
    name: 'Global Hospitals',
    address: '44 Medical Square',
    locality: 'Hilltop',
    stateName: 'Maharashtra',
    cityName: 'Mumbai',
    district_id: 'District-10',
    regionName: 'East',
    pincodeName: '400078',
    email_id: 'contact@globalhospitals.com',
    website: 'https://globalhospitals.com',
    contact_hash: 'hash-global',
    latitude: 15.299326,
    longitude: 74.123993,
    contact_no: '+91-9000000010',
    userName: 'Prathviraj',
  },
];
const hospitalCorporateDataForeignKeys: ForeignKeyConfig<
  (typeof hospitalCorporateData)[0]
>[] = [
  {
    parentModel: 'state_master',
    parentLookupKey: 'name',
    childReferenceKey: 'stateName',
    childForeignKeyField: 'state_id',
  },
  {
    parentModel: 'city_master',
    parentLookupKey: 'name',
    childReferenceKey: 'cityName',
    childForeignKeyField: 'city_id',
  },
  {
    parentModel: 'hospital_region_master',
    parentLookupKey: 'name',
    childReferenceKey: 'regionName',
    childForeignKeyField: 'region_id',
  },
  {
    parentModel: 'pincode_master',
    parentLookupKey: 'name',
    childReferenceKey: 'pincodeName',
    childForeignKeyField: 'pincode_id',
  },
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'created_by',
  },
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'updated_by',
  },
];

const fraudRemarkMasterData: Array<{
  name: string;
  userName: string;
  created_by?: string;
  updated_by?: string;
}> = [
  {
    name: 'Blacklisted Hospital',
    userName: 'Prathviraj',
  },
  {
    name: 'Hospital flagged by RLMU',
    userName: 'Prathviraj',
  },
  {
    name: 'Hospital flagged by other insurance company',
    userName: 'Prathviraj',
  },
  {
    name: 'Others',
    userName: 'Prathviraj',
  },
  {
    name: 'Fake admission',
    userName: 'Prathviraj',
  },
  {
    name: 'Over billing',
    userName: 'Prathviraj',
  },
  {
    name: 'Excluded hospital for retail',
    userName: 'Prathviraj',
  },
  {
    name: 'For anywhere cashless',
    userName: 'Prathviraj',
  },
];
const fraudRemarkMasterDataForeignKeys: ForeignKeyConfig<
  (typeof fraudRemarkMasterData)[0]
>[] = [
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'created_by',
  },
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'updated_by',
  },
];

const hospitals: Array<{
  hospital_no: string;
  rohini_id: string;
  hfr_id: string;
  corporateName: string;
  name: string;
  propreitor_name: string;
  address: string;
  locality: string;
  stateName: string;
  districtName: string;
  cityName: string;
  regionName: string;
  pincode: string;
  email_id: string;
  bed_count: number;
  pan_no: string;
  tan_no: string;
  contact: string;
  website: string;
  is_hospital_registered: boolean;
  registration_no: string;
  registration_authority: string;
  registered_from: Date;
  registered_till: Date;
  latitude: number;
  longitude: number;
  typeName: string;
  levelName: string;
  is_epd_enabled: boolean;
  epd_discount: number;
  epd_tat: number;
  epd_effective_from: Date;
  epd_effective_till: Date;
  is_non_network: boolean;
  status: string;
  fraudRemarkName: string;
  remarks: string;
  healthcareName: string;
  userName: string;
  // Add these missing foreign key fields:
  corporate_id?: string;
  state_id?: string;
  city_id?: string;
  district_id?: string;
  region_id?: string;
  type_id?: string;
  level_care_id?: string;
  fraud_remark_id?: string;
  pincode_id?: string;
  healthcare_type_id?: string;
  created_by?: string;
  updated_by?: string;
}> = [
  {
    hospital_no: 'H123',
    rohini_id: 'R123',
    hfr_id: 'HFR456',
    corporateName: 'Apollo Hospitals',
    name: 'Sunshine Hospital Delhi',
    propreitor_name: 'Dr. Asha Rao',
    address: '123 Health St',
    locality: 'Greenfield',
    stateName: 'Karnataka',
    districtName: 'Mumbai',
    cityName: 'Mangalore',
    regionName: 'North',
    pincode: '400011',
    email_id: 'contact@sunshine.com',
    bed_count: 150,
    pan_no: 'hashedPAN123',
    tan_no: 'hashedTAN456',
    contact: 'hashedContact789',
    website: 'https://sunshinehospital.com',
    is_hospital_registered: true,
    registration_no: 'REG2024XYZ',
    registration_authority: 'Medical Council',
    registered_from: new Date('2024-01-01'),
    registered_till: new Date('2029-12-31'),
    latitude: 12.9716,
    longitude: 77.5946,
    typeName: 'Government',
    levelName: 'Primary',
    is_epd_enabled: true,
    epd_discount: 15.5,
    epd_tat: 48,
    epd_effective_from: new Date('2024-06-01T00:00:00'),
    epd_effective_till: new Date('2026-06-01T00:00:00'),
    is_non_network: false,
    status: 'ACTIVE',
    fraudRemarkName: 'For anywhere cashless',
    remarks: 'Top rated hospital',
    userName: 'Prathviraj',
    healthcareName: 'Hospital/Nursing Home',
  },
];
const hospitalForeignKeys: ForeignKeyConfig<(typeof hospitals)[0]>[] = [
  {
    parentModel: 'state_master',
    parentLookupKey: 'name',
    childReferenceKey: 'stateName',
    childForeignKeyField: 'state_id',
  },
  {
    parentModel: 'district_master',
    parentLookupKey: 'name',
    childReferenceKey: 'districtName',
    childForeignKeyField: 'district_id',
  },
  {
    parentModel: 'city_master',
    parentLookupKey: 'name',
    childReferenceKey: 'cityName',
    childForeignKeyField: 'city_id',
  },
  {
    parentModel: 'hospital_region_master',
    parentLookupKey: 'name',
    childReferenceKey: 'regionName',
    childForeignKeyField: 'region_id',
  },
  {
    parentModel: 'hospital_type_master',
    parentLookupKey: 'name',
    childReferenceKey: 'typeName',
    childForeignKeyField: 'type_id',
  },
  {
    parentModel: 'hospital_care_master',
    parentLookupKey: 'name',
    childReferenceKey: 'levelName',
    childForeignKeyField: 'level_care_id',
  },
  {
    parentModel: 'hospital_fraud_remarks_master',
    parentLookupKey: 'name',
    childReferenceKey: 'fraudRemarkName',
    childForeignKeyField: 'fraud_remark_id',
  },
  {
    parentModel: 'hospital_corporate',
    parentLookupKey: 'name',
    childReferenceKey: 'corporateName',
    childForeignKeyField: 'corporate_id',
  },
  {
    parentModel: 'pincode_master',
    parentLookupKey: 'name',
    childReferenceKey: 'pincode',
    childForeignKeyField: 'pincode_id',
  },
  {
    parentModel: 'healthcare_type_master',
    parentLookupKey: 'name',
    childReferenceKey: 'healthcareName',
    childForeignKeyField: 'healthcare_type_id',
  },
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'created_by',
  },
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'updated_by',
  },
];

const healthCareMaster: Array<{
  name: string;
  userName: string;
  code: string;
  created_by?: string;
  updated_by?: string;
}> = [
  {
    name: 'Hospital/Nursing Home',
    code: 'HS',
    userName: 'Prathviraj',
  },
  {
    name: 'Clinic',
    code: 'CL',
    userName: 'Prathviraj',
  },
  {
    name: 'Consultant',
    code: 'CN',
    userName: 'Prathviraj',
  },
  {
    name: 'Pharmacy',
    code: 'PH',
    userName: 'Prathviraj',
  },
  {
    name: 'Diagnostic Center',
    code: 'DC',
    userName: 'Prathviraj',
  },
  {
    name: 'Nursing Agency',
    code: 'NS',
    userName: 'Prathviraj',
  },
  {
    name: 'Blood Bank',
    code: 'BB',
    userName: 'Prathviraj',
  },
  {
    name: 'Ambulance',
    code: 'AM',
    userName: 'Prathviraj',
  },
  {
    name: 'SOS',
    code: 'SO',
    userName: 'Prathviraj',
  },
  {
    name: 'Wellness Center',
    code: 'WC',
    userName: 'Prathviraj',
  },
  {
    name: 'Non Network',
    code: 'NN',
    userName: 'Prathviraj',
  },
  {
    name: 'International Hospital',
    code: 'IH',
    userName: 'Prathviraj',
  },
  {
    name: 'Gym',
    code: 'GY',
    userName: 'Prathviraj',
  },
  {
    name: 'Salon',
    code: 'SL',
    userName: 'Prathviraj',
  },
  {
    name: 'Spa',
    code: 'SP',
    userName: 'Prathviraj',
  },
  {
    name: 'Yoga Centers',
    code: 'YC',
    userName: 'Prathviraj',
  },
  {
    name: 'Slimming Centers',
    code: 'SC',
    userName: 'Prathviraj',
  },
  {
    name: 'Ambulance',
    code: 'AM',
    userName: 'Prathviraj',
  },
  {
    name: 'Blood Bank',
    code: 'BB',
    userName: 'Prathviraj',
  },
  {
    name: 'Dental',
    code: 'DN',
    userName: 'Prathviraj',
  },
  {
    name: 'Spectacles',
    code: 'ST',
    userName: 'Prathviraj',
  },
  {
    name: 'Home Care Services',
    code: 'HC',
    userName: 'Prathviraj',
  },
  {
    name: 'Hair and Skin Care',
    code: 'HSC',
    userName: 'Prathviraj',
  },
];
const healthCareMasterForeignKeys: ForeignKeyConfig<
  (typeof healthCareMaster)[0]
>[] = [
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'created_by',
  },
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'updated_by',
  },
];

const doctorSpecialityMaster: Array<{
  name: string;
  userName: string;
  created_by?: string;
  updated_by?: string;
}> = [
  {
    name: 'General Practitioner (GP)',
    userName: 'Prathviraj',
  },
  {
    name: 'Pediatrician',
    userName: 'Prathviraj',
  },
  {
    name: 'Dermatologist',
    userName: 'Prathviraj',
  },
  {
    name: 'Cardiologist',
    userName: 'Prathviraj',
  },
  {
    name: 'Ophthalmologist',
    userName: 'Prathviraj',
  },
  {
    name: 'Orthopaedic Surgeon',
    userName: 'Prathviraj',
  },
  {
    name: 'Neurologist',
    userName: 'Prathviraj',
  },
  {
    name: 'Psychiatrist',
    userName: 'Prathviraj',
  },
  {
    name: 'OBS/GYN',
    userName: 'Prathviraj',
  },
  {
    name: 'Anesthesiologist',
    userName: 'Prathviraj',
  },
  {
    name: 'Radiologist',
    userName: 'Prathviraj',
  },
  {
    name: 'ENT Specialist',
    userName: 'Prathviraj',
  },
  {
    name: 'Urologist',
    userName: 'Prathviraj',
  },
  {
    name: 'Endocrinologist',
    userName: 'Prathviraj',
  },
  {
    name: 'Gastroenterologist',
    userName: 'Prathviraj',
  },
  {
    name: 'Pulmonologist',
    userName: 'Prathviraj',
  },
  {
    name: 'Nephrologist',
    userName: 'Prathviraj',
  },
  {
    name: 'Oncologist',
    userName: 'Prathviraj',
  },
  {
    name: 'Rheumatologist',
    userName: 'Prathviraj',
  },
  {
    name: 'Allergist/Immunologist',
    userName: 'Prathviraj',
  },
  {
    name: 'Emergency Medicine Physician',
    userName: 'Prathviraj',
  },
  {
    name: 'Pathologist',
    userName: 'Prathviraj',
  },
  {
    name: 'Infectious Disease Specialist',
    userName: 'Prathviraj',
  },
];
const doctorSpecialityMasterForeignKeys: ForeignKeyConfig<
  (typeof doctorSpecialityMaster)[0]
>[] = [
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'created_by',
  },
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'updated_by',
  },
];

const doctorQualifications: Array<{
  name: string;
  userName: string;
  created_by?: string;
  updated_by?: string;
}> = [
  {
    name: 'BHMS',
    userName: 'Prathviraj',
  },
  {
    name: 'BAMS',
    userName: 'Prathviraj',
  },
  {
    name: 'BUMS',
    userName: 'Prathviraj',
  },
  {
    name: 'BPT',
    userName: 'Prathviraj',
  },
  {
    name: 'MPT',
    userName: 'Prathviraj',
  },
  {
    name: 'BIMS',
    userName: 'Prathviraj',
  },
  {
    name: 'MBBS',
    userName: 'Prathviraj',
  },
  {
    name: 'MD',
    userName: 'Prathviraj',
  },
  {
    name: 'MS',
    userName: 'Prathviraj',
  },
  {
    name: 'BDS',
    userName: 'Prathviraj',
  },
  {
    name: 'MDS',
    userName: 'Prathviraj',
  },
  {
    name: 'DHMS',
    userName: 'Prathviraj',
  },
  {
    name: 'DA',
    userName: 'Prathviraj',
  },
  {
    name: 'DCH',
    userName: 'Prathviraj',
  },
  {
    name: 'DGO',
    userName: 'Prathviraj',
  },
  {
    name: 'DLO',
    userName: 'Prathviraj',
  },
  {
    name: 'DMRD',
    userName: 'Prathviraj',
  },
  {
    name: 'DO',
    userName: 'Prathviraj',
  },
  {
    name: 'PGDMCH',
    userName: 'Prathviraj',
  },
  {
    name: 'PGDIM',
    userName: 'Prathviraj',
  },
  {
    name: 'PGMT',
    userName: 'Prathviraj',
  },
  {
    name: 'PGD-MLRN',
    userName: 'Prathviraj',
  },
  {
    name: 'PGD-CM',
    userName: 'Prathviraj',
  },
  {
    name: 'PGD-OTN',
    userName: 'Prathviraj',
  },
  {
    name: 'BMLT',
    userName: 'Prathviraj',
  },
];
const doctorQualificationsForeignKeys: ForeignKeyConfig<
  (typeof doctorQualifications)[0]
>[] = [
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'created_by',
  },
  {
    parentModel: 'user',
    parentLookupKey: 'name',
    childReferenceKey: 'userName',
    childForeignKeyField: 'updated_by',
  },
];

/**
 * Seeds the user model with initial data.
 */
async function run() {
  try {
    await seedModel(prisma, 'user' as keyof PrismaService, userData);

    await seedWithMultipleParents(
        prisma,
        'hospital_speciality_master', // model name in PrismaService
        hospitalSpecialtyMasterData,
        hospitalSpecialtyMasterDataForeignKeys,
    );

    await seedWithMultipleParents(
        prisma,
        'hospital_type_master', // model name in PrismaService
        hospitalTypeMasterData,
        hospitalTypeMasterDataForeignKeys,
    );

    await seedWithMultipleParents(
        prisma,
        'hospital_care_master', // model name in PrismaService
        hospitalCareMasterData,
        hospitalCareMasterDataForeignKeys,
    );

    await seedModel(
        prisma,
      'hospital_discount_master' as keyof PrismaService,
      hospitalDiscountMasterData,
    );

    await seedWithMultipleParents(
        prisma,
        'hospital_room_types', // model name in PrismaService
        hospitalRoomTypesData,
        hospitalRoomTypesDataForeignKeys,
    );

    await seedWithMultipleParents(
        prisma,
        'hospital_room_categories', // model name in PrismaService
        hospitalRoomCategoriesData,
        hospitalRoomCategoriesDataForeignKeys,
    );

    await seedWithMultipleParents(
        prisma,
        'state_master', // model name in PrismaService
        stateMasterData,
        stateMasterDataForeignKeys,
    );

    await seedWithMultipleParents(
        prisma,
        'city_master', // model name in PrismaService
        cityMasterData,
        cityMasterDataForeignKeys,
    );

    await seedWithMultipleParents(
        prisma,
        'district_master', // model name in PrismaService
        districtMasterData,
        districtMasterDataForeignKeys,
    );

    await seedModel(
        prisma,
      'hospital_region_master' as keyof PrismaService,
      regionMasterData,
    );

    await seedWithMultipleParents(
        prisma,
        'pincode_master', // model name in PrismaService
        pincodeData,
        pincodeForeignKeys,
    );

    await seedWithMultipleParents(
        prisma,
        'hospital_corporate', // model name in PrismaService
        hospitalCorporateData,
        hospitalCorporateDataForeignKeys,
    );

    await seedWithMultipleParents(
        prisma,
        'hospital_fraud_remarks_master', // model name in PrismaService
        fraudRemarkMasterData,
        fraudRemarkMasterDataForeignKeys,
    );

    await seedWithMultipleParents(
        prisma,
        'healthcare_type_master', // model name in PrismaService
        healthCareMaster,
        healthCareMasterForeignKeys,
    );

    await seedWithMultipleParents(
        prisma,
        'hospitals', // model name in PrismaService
        hospitals,
        hospitalForeignKeys,
    );

    await seedWithMultipleParents(
        prisma,
        'doctor_speciality_master', // model name in PrismaService
        doctorSpecialityMaster,
        doctorSpecialityMasterForeignKeys,
    );
    await seedWithMultipleParents(
        prisma,
        'doctor_qualification_master', // model name in PrismaService
        doctorQualifications,
        doctorQualificationsForeignKeys,
    );

    console.log('Data seeded successfully.');
  } catch (error) {
    console.error('Error seeding data:', error);
  } finally {
    await prisma.$disconnect();
  }
}

export { run };

if (require.main === module) {
  run();
}
