/**
 @file        <file name>
 @description  <description>
 @author      <Your Name>
 @created     <YYYY-MM-DD>
**/

import { Test, TestingModule } from '@nestjs/testing';
import { PrismaService } from './prisma.service';
import * as nestCommonUtils from 'nest-common-utilities';
import { Prisma } from '@prisma/client';

// Mocks
jest.mock('nest-common-utilities', () => ({
  Logger: jest.fn().mockImplementation(() => ({
    info: jest.fn(),
    error: jest.fn(),
  })),
  setEncryptedFields: jest.fn(),
  createExtendedPrisma: jest.fn().mockReturnValue({ $extended: true }),
}));

describe('PrismaService', () => {
  let service: PrismaService;
  let loggerSpy: jest.Mocked<any>;

  const mockQueryEvent: Prisma.QueryEvent = {
    timestamp: new Date(),
    query: 'SELECT * FROM users',
    params: '[]',
    duration: 10,
    target: 'db',
  };

  let originalEnv: string | undefined;

  beforeEach(async () => {
    originalEnv = process.env.NODE_ENV;
    jest.clearAllMocks();

    const module: TestingModule = await Test.createTestingModule({
      providers: [PrismaService],
    }).compile();

    service = module.get<PrismaService>(PrismaService);
    const MockedLogger = nestCommonUtils.Logger as jest.MockedClass<
      typeof nestCommonUtils.Logger
    >;
    loggerSpy = MockedLogger.mock.instances[0];
  });

  afterEach(() => {
    process.env.NODE_ENV = originalEnv;
  });

  it('should be defined', () => {
    expect(service).toBeDefined();
  });

  it('should call setEncryptedFields and createExtendedPrisma', () => {
    expect(nestCommonUtils.setEncryptedFields).toHaveBeenCalled();
    expect(nestCommonUtils.createExtendedPrisma).toHaveBeenCalledWith(service);
    expect(service).toHaveProperty('$extended', true);
  });

  it('should log query in dev environment', () => {
    process.env.NODE_ENV = 'dev';

    const testService = new PrismaService();
    const queryHandler = (testService as any)._events?.['query']?.[0];
    const queryEvent: Prisma.QueryEvent = {
      timestamp: new Date(),
      query: 'SELECT * FROM hospital',
      params: '[1]',
      duration: 5,
      target: 'db',
    };

    if (queryHandler) {
      queryHandler(mockQueryEvent);
      (testService as any).emit('query', queryEvent);
      expect(loggerSpy.info).toHaveBeenCalledWith(
          expect.stringContaining('Query: SELECT * FROM users'),
      );
    } else {
      // fallback in case _events is inaccessible
      expect(true).toBe(true);
    }
  });

  it('should NOT bind query logging if not in dev environment', () => {
    process.env.NODE_ENV = 'production';

    const prodService = new PrismaService();
    const queryHandler = (prodService as any)._events?.['query'];

    expect(queryHandler).toBeUndefined(); // logger not bound
  });
});
