/**
 @file        <file name>
 @description  <description>
 @author      <Your Name>
 @created     <YYYY-MM-DD>
**/
import { Transport } from '@nestjs/microservices';
import { MICROSERVICE_CONFIGS } from './microservices.config';
import { CustomClientProviders } from './microservice.registration';
import { ClientProxyFactory } from 'nest-common-utilities';
import { FactoryProvider } from '@nestjs/common/interfaces';

jest.mock('nest-common-utilities', () => ({
  ClientProxyFactory: {
    create: jest.fn(),
  },
  ClientProxyWrapper: jest
      .fn()
      .mockImplementation((client) => ({ wrappedClient: client })),
}));

describe('CustomClientProviders', () => {
  it('should export a provider for each microservice config', () => {
    expect(Array.isArray(CustomClientProviders)).toBe(true);
    expect(CustomClientProviders).toHaveLength(MICROSERVICE_CONFIGS.length);
  });

  it('should provide correct tokens and factory instances', () => {
    MICROSERVICE_CONFIGS.forEach((config, index) => {
      const provider = CustomClientProviders[index];

      // Type narrowing using type assertion to FactoryProvider
      const factoryProvider = provider as FactoryProvider;

      expect(factoryProvider.provide).toBe(config.name);

      const mockClientProxy = { mock: 'client' };
      (ClientProxyFactory.create as jest.Mock).mockReturnValueOnce(
          mockClientProxy,
      );

      const result = factoryProvider.useFactory();

      expect(ClientProxyFactory.create).toHaveBeenCalledWith({
        transport: Transport.TCP,
        options: {
          host: config.host,
          port: config.port,
        },
      });

      expect(result).toEqual({ wrappedClient: mockClientProxy });
    });
  });
});
