/**
 @file        <file name>
 @description  <description>
 @author      <Your Name>
 @created     <YYYY-MM-DD>
**/
import { Test, TestingModule } from '@nestjs/testing';
import { MicroserviceModule } from './microservice.module';
import { MicroserviceHealthService } from './microservice.service';
import { MICROSERVICE_CONFIGS } from './microservices.config';

describe('MicroserviceModule', () => {
  let module: TestingModule;

  beforeAll(async () => {
    module = await Test.createTestingModule({
      imports: [MicroserviceModule],
    }).compile();
  });

  it('should be defined', () => {
    expect(module).toBeDefined();
  });

  it('should provide MicroserviceHealthService', () => {
    const service = module.get<MicroserviceHealthService>(
        MicroserviceHealthService,
    );
    expect(service).toBeInstanceOf(MicroserviceHealthService);
  });

  it('should provide all custom client providers', () => {
    for (const config of MICROSERVICE_CONFIGS) {
      const provider = module.get(config.name);
      expect(provider).toBeDefined();
    }
  });
});
