/**
 @file        <file name>
 @description  <description>
 @author      <Your Name>
 @created     <YYYY-MM-DD>
**/
import { ValidLocationFieldsWithName } from './validator';
import { ValidationArguments } from 'class-validator';

describe('ValidLocationFieldsWithName', () => {
  const validator = new ValidLocationFieldsWithName();
  it(
      'should return false if location fields present but Name is missing',
      () => {
        const obj = {
          hospitalName: undefined,
          stateId: 'state-1',
          cityId: 'city-1',
          pincodeId: 'pin-1',
        };
        const result = validator.validate(undefined, {
          object: obj,
        } as ValidationArguments);
        expect(result).toBe(false);
        expect(validator.defaultMessage()).toBe(
            'stateId, cityId, pincodeId are only allowed when name is provided',
        );
      });

  it(
      'should return false if hospitalId is present with location fields',
      () => {
        const obj = {
          hospitalId: 'hospital-123',
          stateId: 'state-1',
          cityId: 'city-1',
          pincodeId: 'pin-1',
        };
        const result = validator.validate(undefined, {
          object: obj,
        } as ValidationArguments);
        expect(result).toBe(false);
        expect(validator.defaultMessage()).toBe(
            'stateId, cityId, pincodeId are only allowed when name is provided',
        );
      });

  it(
      'should return false if emailId is present with location fields',
      () => {
        const obj = {
          emailId: 'test@example.com',
          stateId: 'state-1',
          cityId: 'city-1',
          pincodeId: 'pin-1',
        };
        const result = validator.validate(undefined, {
          object: obj,
        } as ValidationArguments);
        expect(result).toBe(false);
        expect(validator.defaultMessage()).toBe(
            'stateId, cityId, pincodeId are only allowed when name is provided',
        );
      });

  it(
      'Return true when location fields are present and hospital also provided',
      () => {
        const obj = {
          hospitalName: 'Test Hospital',
          stateId: 'state-1',
          cityId: 'city-1',
          pincodeId: 'pin-1',
        };
        const result = validator.validate(undefined, {
          object: obj,
        } as ValidationArguments);
        expect(result).toBe(true);
      });

  it('should return true when no location fields are provided', () => {
    const obj = {
      hospitalName: 'Test Hospital',
    };
    const result = validator.validate(undefined, {
      object: obj,
    } as ValidationArguments);
    expect(result).toBe(true);
  });

  it(
      'Return false if email present with location and Name also provided',
      () => {
        const obj = {
          hospitalName: 'Test Hospital',
          emailId: 'test@example.com',
          pincodeId: 'PIN123',
        };
        const validator = new ValidLocationFieldsWithName();
        const result =
    validator.validate(undefined, { object: obj } as ValidationArguments);
        expect(result).toBe(false);
      });
});
