/**
 @file        <file name>
 @description  <description>
 @author      <Your Name>
 @created     <YYYY-MM-DD>
**/

import { Controller, Post, Body } from '@nestjs/common';
import { Logger } from 'nest-common-utilities';
import { ApiOperation, ApiResponse } from '@nestjs/swagger';
import { HospitalService } from './hospital.service';
import {
  GetHospitalsRequestDto,
} from './dto/get-hospitals/get-hospital-list-request.dto';
import {
  GetHospitalsResponseDto,
} from './dto/get-hospitals/get-hospital-list-response.dto';

/**
 * Controller to manage hospital-related API endpoints.
 */
@Controller('hospital')
export class HospitalController {
  private logger = new Logger(HospitalController.name);

  /**
   * Initializes the HospitalController.
   *
   * @param hospitalService - Service for handling hospital business logic.
   */
  constructor(private readonly hospitalService: HospitalService) { }

  /**
   * Get hospital list based on the request parameters.
   *
   * @param {GetHospitalsRequestDto} GetHospitalsRequestDto - The data
   * transfer object containing the information for creating a new user.
   * @returns {Promise<GetHospitalsResponseDto>} The created user information.
   */
  @Post('/list')
  @ApiOperation({ summary: 'Get list of hospitals' })
  @ApiResponse({
    status: 200,
    description: 'Hospital list successfully fetched.',
  })
  @ApiResponse({ status: 400, description: 'Bad Request.' })
  async getHospitals(
    @Body() GetHospitalsRequestDto: GetHospitalsRequestDto,
  ): Promise<GetHospitalsResponseDto> {
    this.logger.info('Get Hospitals Controller', {
      requestBody: GetHospitalsRequestDto,
    });
    const { hospitalName, hospitalId, emailId } = GetHospitalsRequestDto;
    let hospitals: GetHospitalsResponseDto = { list: [], totalCount: 0 };

    if (hospitalName) {
      hospitals = await this.hospitalService.getHospitalsByName(
        GetHospitalsRequestDto,
      );
    } else if (hospitalId) {
      hospitals = await this.hospitalService.getHospitalByHospitalId(
        GetHospitalsRequestDto,
      );
    } else if (emailId) {
      hospitals = await this.hospitalService.getHospitalByEmailId(
        GetHospitalsRequestDto,
      );
    }

    return hospitals;
  }
}
