/**
 @file        <file name>
 @description  <description>
 @author      <Your Name>
 @created     <YYYY-MM-DD>
**/
import { Expose, Type, Transform } from 'class-transformer';
import { ApiProperty } from '@nestjs/swagger';
import * as moment from 'moment';
import { IsUUID } from 'class-validator';

/**
 *
 */
export class HospitalItemDto {
  @Expose()
  @ApiProperty({
    example: '550e8400-e29b-41d4-a716-446655440002',
    description: 'UUID of the hospital',
  })
  id: string;

  @Expose()
  @ApiProperty({
    example: 'HSP-23HD',
    description: 'Hospital number/code',
  })
  hospitalNo: string;

  @Expose()
  @ApiProperty({
    example: 'ROH001',
    description: 'Rohini ID',
  })
  rohiniId: string;

  @Expose()
  @ApiProperty({
    example: 'ROH001',
    description: 'HFR ID',
  })
  hfrId: string;

  @Expose()
  @ApiProperty({
    example: 'Apollo Hospitals',
    description: 'Name of the hospitals',
  })
  hospitalName: string;

  @Expose()
  @ApiProperty({
    example: 'Apollo Hospitals',
    description: 'Propreitor Name',
  })
  propreitorName: string;

  @Expose()
  @ApiProperty({
    example: 'Apollo Hospitals',
    description: 'Propreitor Name',
  })
  state: string;

  @Expose()
  @ApiProperty({
    example: 'Apollo Hospitals',
    description: 'Propreitor Name',
  })
  city: string;

  @Expose()
  @ApiProperty({
    example: 'Mumbai',
    description: 'Address of the hospitals',
  })
  address: string;

  @Expose()
  @ApiProperty({
    example: 'Downtown',
    description: 'Locality of the hospitals',
  })
  locality: string;

  @Expose()
  @ApiProperty({
    example: '667333', // needs to be changed
    description: 'Pincode of the hospitals',
  })
  pincode: string;

  @Expose()
  @ApiProperty({
    example: 'apollo@hospital.com',
    description: 'Email ID of the hospitals',
  })
  emailId: string;

  @Expose()
  @ApiProperty({
    example: 'www.apollohospital.com',
    description: 'Website of the hospitals',
  })
  website: string;

  @Expose()
  @Type(() => Boolean)
  @ApiProperty({
    example: true,
    description: 'Whether the hospital is registered or not',
  })
  isHospitalRegistered: boolean;

  @Expose()
  @ApiProperty({
    example: 'knvkj7864',
    description: 'Registration number of the hospitals',
  })
  registrationNo: string;

  @Expose()
  @ApiProperty({
    example: 'knvkj7864',
    description: 'Registration authority of the hospitals',
  })
  registrationAuthority: string;

  @Expose()
  @Transform(({ value }) =>
    value ? moment(value).format('YYYY-MM-DD HH:mm:ss') : null,
  )
  @ApiProperty({
    example: '2025-05-30T14:45:00.000Z',
    description: 'Registered from date (ISO 8601 format)',
  })
  registeredFrom: string;

  @Expose()
  @Transform(({ value }) =>
    value ? moment(value).format('YYYY-MM-DD HH:mm:ss') : null,
  )
  @ApiProperty({
    example: '2025-12-31T23:59:59.000Z',
    description: 'Registered till date (ISO 8601 format)',
  })
  registeredTill: string;

  @Expose()
  @Type(() => Number)
  @ApiProperty({
    example: '76.4878795',
    description: 'Latitude',
  })
  latitude: number;

  @Expose()
  @Type(() => Number)
  @ApiProperty({
    example: '76.4878795',
    description: 'Longitude',
  })
  longitude: number;

  @Expose()
  @ApiProperty({
    example: '7208806389',
    description: 'Contact number of the hospitals',
  })
  contactNo: string;

  @Expose()
  @Type(() => Boolean)
  @ApiProperty({
    example: true,
    description: 'Whether the hospital epd enabled or not',
  })
  isEPDEnabled: boolean;

  @Expose()
  @Type(() => Boolean)
  @ApiProperty({
    example: true,
    description: 'Whether the hospital non network or not',
  })
  isNonNetwork: boolean;

  @Expose()
  @ApiProperty({
    example: 'ACTIVE',
    description: 'Status of the hospitals',
  })
  status: string;

  @Expose()
  @ApiProperty({
    example: 'Best Hospital',
    description: 'Remarks of the hospitals',
  })
  remarks: string;

  @Expose()
  @IsUUID()
  @ApiProperty({
    example: 'dd1d8fed-9b8f-4166-96fe-7569d1f6f520',
    description: 'State ID',
  })
  stateId: string;

  @Expose()
  @IsUUID()
  @ApiProperty({
    example: 'dd1d8fed-9b8f-4166-96fe-7569d1f6f520',
    description: 'City ID',
  })
  cityId: string;

  @Expose()
  @IsUUID()
  @ApiProperty({
    example: 'dd1d8fed-9b8f-4166-96fe-7569d1f6f520',
    description: 'Pincode ID',
  })
  pincodeId: string;
}
