/**
 * @file        get-hospital-list-response.dto.ts
 * @description DTO for hospital list response used in GetHospitals API
 * @author      Prathviraj Thokal
 * @created     2024-06-23
 */
import { Expose, Type } from 'class-transformer';
import { ApiProperty } from '@nestjs/swagger';
import { HospitalItemDto } from './hospital-list-item.dto';

export class GetHospitalsResponseDto {
  @Expose()
  @ApiProperty({
    example: 15,
    description: 'Total count of hospitals matching the criteria',
  })
  totalCount: number;

  @Expose()
  @Type(() => HospitalItemDto)
  @ApiProperty({
    type: [HospitalItemDto],
    description: 'List of hospitals',
  })
  list: HospitalItemDto[];
}
