/**
 @file        <file name>
 @description  <description>
 @author      <Your Name>
 @created     <YYYY-MM-DD>
**/
import {
  IsString,
  IsEmail,
  IsOptional,
  IsNumber,
  IsIn,
  IsUUID,
  Validate,
  IsNotEmpty,
  IsArray,
  ArrayNotEmpty,
  ArrayUnique,
} from 'class-validator';
import { Type } from 'class-transformer';
import { ApiProperty } from '@nestjs/swagger';
import {
  OnlyOneSearchField,
  ValidLocationFieldsWithName,
} from '../../validator/validator';

/**
 *
 */
export class GetHospitalsRequestDto {
  @IsOptional()
  @IsString({ message: 'Name must be a string' })
  @ApiProperty({
    example: 'City Hospital',
    description: 'Name of the hospital',
  })
    hospitalName?: string;

  @IsOptional()
  @IsString({ message: 'Hospital ID must be a string' })
  @ApiProperty({ example: 'HOSP1234', description: 'Hospital ID' })
    hospitalId?: string;

  @IsOptional()
  @IsEmail({}, { message: 'Invalid email format' })
  @ApiProperty({
    example: 'niveus@example.com',
    description: 'Email of the hospital',
  })
    emailId?: string;

  @IsOptional()
  @IsUUID()
  @IsNotEmpty({ message: 'State ID must be a valid UUID' })
  @ApiProperty({ example: 'uuid', description: 'State ID' })
    stateId?: string;

  @IsOptional()
  @IsUUID()
  @IsNotEmpty({ message: 'City ID must be a valid UUID' })
  @ApiProperty({ example: 'uuid', description: 'City ID' })
    cityId?: string;

  @IsOptional()
  @IsUUID()
  @IsNotEmpty({ message: 'Pincode ID must be a valid UUID' })
  @ApiProperty({ example: 'uuid', description: 'Pincode ID' })
    pincodeId?: string;

  @IsOptional()
  @IsArray({ message: 'Status must be an array' })
  @ArrayNotEmpty({ message: 'Status array should not be empty' })
  @ArrayUnique({ message: 'Status values must be unique' })
  @IsIn(
      [
        'ACTIVE',
        'TEMPORARY_BLOCKED',
        'PERMANENTLY_BLOCKED',
        'SUSPECTED',
        'EXCLUDED',
        'UNDER_MODIFICATION',
        'BLOCK',
      ],
      {
        each: true,
        message:
        `Each status must be one of: 
        ACTIVE, 
        TEMPORARY_BLOCKED, 
        PERMANENTLY_BLOCKED, 
        SUSPECTED, 
        EXCLUDED, 
        UNDER_MODIFICATION, 
        BLOCK`,
      },
  )
  @ApiProperty({
    example: ['ACTIVE', 'BLOCK'],
    isArray: true,
    description: 'List of hospital statuses',
  })
    status?: string[];

  @IsOptional()
  @Type(() => Number)
  @IsNumber({}, { message: 'Page must be a number' })
  @ApiProperty({ example: 1, description: 'Page number' })
    page?: number;

  @Type(() => Number)
  @IsNumber({}, { message: 'Limit must be a number' })
  @ApiProperty({ example: 10, description: 'Records per page' })
    limit: number;

  @Validate(OnlyOneSearchField)
  @Validate(ValidLocationFieldsWithName)
  readonly _customValidationPlaceholder?: boolean;
}
