/**
 @file        <file name>
 @description  <description>
 @author      <Your Name>
 @created     <YYYY-MM-DD>
**/

import { Test, TestingModule } from '@nestjs/testing';
import { HealthCheckController } from './health-check.controller';
import { HealthCheckService, HttpHealthIndicator } from '@nestjs/terminus';

// Helper function to create the testing module
/**
 * Creates and compiles a testing
 * module with mocked HealthCheckService and HttpHealthIndicator.
 *
 * @returns {Promise<TestingModule>} A promise that
 * resolves to the compiled testing module.
 */
async function createTestingModule(): Promise<TestingModule> {
  return await Test.createTestingModule({
    controllers: [HealthCheckController],
    providers: [
      {
        provide: HealthCheckService,
        useValue: {
          check: jest.fn().mockImplementation((checks) => {
            checks[0](); // Execute the check function
            return Promise.resolve({
              status: 'ok',
              info: { google: { status: 'up' } },
            });
          }),
        },
      },
      {
        provide: HttpHealthIndicator,
        useValue: {
          pingCheck: jest.fn().mockResolvedValue({ google: { status: 'up' } }),
        },
      },
    ],
  }).compile();
}

describe('HealthCheckController', () => {
  let controller: HealthCheckController;
  let healthCheckService: HealthCheckService;
  let httpHealthIndicator: HttpHealthIndicator;

  beforeEach(async () => {
    const module = await createTestingModule();
    controller = module.get<HealthCheckController>(HealthCheckController);
    healthCheckService = module.get<HealthCheckService>(HealthCheckService);
    httpHealthIndicator = module.get<HttpHealthIndicator>(HttpHealthIndicator);
  });

  it('should be defined', () => {
    expect(controller).toBeDefined();
  });

  describe('check', () => {
    it(
        `should call health.check with the 
      correct parameters and return the result`,
        async () => {
          const result = await controller.check();

          expect(healthCheckService.check).toHaveBeenCalledWith([
            expect.any(Function),
          ]);
          expect(httpHealthIndicator.pingCheck).toHaveBeenCalledWith(
              'google',
              'https://www.google.com',
          );
          expect(result).toEqual({
            status: 'ok',
            info: { google: { status: 'up' } },
          });
        });

    it('should handle errors gracefully', async () => {
      jest
          .spyOn(healthCheckService, 'check')
          .mockRejectedValue(new Error('Health check failed'));

      await expect(controller.check()).rejects.toThrow('Health check failed');
    });
  });
});
