/**
 @file        <file name>
 @description  <description>
 @author      <Your Name>
 @created     <YYYY-MM-DD>
**/

import { ApiProperty } from '@nestjs/swagger';

/**
 *
 */
export class ListDoctorsResponseDto {
  @ApiProperty({
    example: '550e8400-e29b-41d4-a716-446655440002',
    description: 'Doctor ID',
  })
    id: string;

  @ApiProperty({
    example: 'Dr. Prathamesh Pai',
    description: 'Doctor name',
  })
    doctorName: string;

  @ApiProperty({
    example: 'HR100928',
    description: 'Doctor registration number',
  })
    doctorRegNo: string;

  @ApiProperty({
    example: 'ABCD1234E',
    description: 'PAN number',
    nullable: true,
  })
    panNo: string;

  @ApiProperty({
    example: '550e8400-e29b-41d4-a716-446655440032',
    description: 'Speciality ID',
  })
    specialityId: string;

  @ApiProperty({
    example: 'Neurologist',
    description: 'Speciality name',
  })
    speciality: string;

  @ApiProperty({
    type: [Object],
    example: [
      {
        id: '550e8400-e29b-41d4-a716-446655670002',
        qualification: 'MD',
      },
      {
        id: '550e8400-e29b-41d4-a716-446655670002',
        qualification: 'MBBS',
      },
    ],
    description: 'Array of doctor qualifications',
  })
    qualificationIds: Array<{
      id: string;
      qualification: string;
    }>;

  @ApiProperty({
    example: '+917548572893',
    description: 'Contact number',
  })
    contactNo: string;

  @ApiProperty({
    example: 'ADCVB987GH',
    description: 'HPR code',
  })
    hprCode: string;

  @ApiProperty({
    example: 'pratham7@gmail.com',
    description: 'Email ID (optional)',
    nullable: true,
  })
    emailId: string | null;

  @ApiProperty({
    example: 'Marol 5th main',
    description: 'Address',
  })
    address: string;

  @ApiProperty({
    example: '550e8400-e29b-41d4-a716-556655670002',
    description: 'Pincode ID',
  })
    pincodeId: string;

  @ApiProperty({
    example: 400078,
    description: 'Pincode',
  })
    pincode: string;

  @ApiProperty({
    example: 14.910813,
    description: 'Latitude',
  })
    latitude: string | null;

  @ApiProperty({
    example: 79.910813,
    description: 'Longitude',
  })
    longitude: string | null;
}
