/**
 @file        <file name>
 @description  <description>
 @author      <Your Name>
 @created     <YYYY-MM-DD>
**/

import {
  IsString,
  IsNumber,
  IsOptional,
  IsUUID,
} from 'class-validator';
import { ApiProperty } from '@nestjs/swagger';

/**
 *
 */
export class ListDoctorsRequestDto {
  @IsString()
  @ApiProperty({
    example: 'Dr. Prathamesh Pai',
    description: 'Name of the doctor',
    required: true,
  })
  doctorName: string;

  @IsString()
  @IsOptional()
  @ApiProperty({
    example: 'HR100928',
    description: 'Registration number of the doctor',
    required: false,
  })
  doctorRegNo?: string;

  @IsString()
  @IsOptional()
  @ApiProperty({
    example: 'pratham7@gmail.com',
    description: 'Email ID of the doctor',
    required: false,
  })
  emailId?: string;

  @IsString()
  @IsOptional()
  @ApiProperty({
    example: '+917548572893',
    description: 'Mobile number of the doctor',
    required: false,
  })
  mobileNo?: string;

  @ApiProperty({
    description: 'HPR code',
    example: 'ADCVB987GH',
    required: false,
  })
  @IsOptional()
  @IsString()
  hprCode?: string;

  @ApiProperty({
    description: 'PAN number',
    example: 'CHPI789323',
    required: false,
  })
  @IsOptional()
  @IsString()
  panNo?: string;

  @ApiProperty({
    description: 'Speciality ID',
    example: '550e8400-e29b-41d4-a716-446655440002',
    required: false,
  })
  @IsUUID()
  @IsOptional()
  specialityId?: string;

  @IsNumber()
  @ApiProperty({
    example: 1,
    description: 'Page number for pagination',
    required: true,
    default: 1,
  })
  page?: number = 1;

  @IsNumber()
  @ApiProperty({
    example: 10,
    description: 'Number of items per page',
    required: true,
    default: 10,
  })
  limit?: number = 10;
}
