/**
 @file        <file name>
 @description  <description>
 @author      <Your Name>
 @created     <YYYY-MM-DD>
**/
import { Module, MiddlewareConsumer, NestModule } from '@nestjs/common';
import { APP_GUARD, APP_INTERCEPTOR, Reflector } from '@nestjs/core';
import { AppController } from './app.controller';
import { AppService } from './app.service';
import { HealthCheckModule } from './health-check/health-check.module';
import { ConfigModule } from '@nestjs/config';
import { ThrottlerModule, ThrottlerStorage } from '@nestjs/throttler';
import {
  GlobalThrottlerGuard,
  TraceIdInterceptor,
} from 'nest-common-utilities';
import { MicroserviceModule } from './microservices/microservice.module';
import { HospitalModule } from './hospital/hospital.module';
import { DoctorModule } from './doctor/doctor.module';


/**
 * The root application module that imports and configures all feature modules,
 * global services, and guards for the application.
 */
@Module({
  imports: [
    ThrottlerModule.forRoot(),
    ConfigModule.forRoot({ isGlobal: true }),
    HealthCheckModule,
    MicroserviceModule,
    HospitalModule,
    DoctorModule,
  ],
  controllers: [AppController],
  providers: [
    AppService,
    {
      provide: APP_INTERCEPTOR,
      useClass: TraceIdInterceptor,
    },
    {
      provide: APP_GUARD,
      useFactory: (storage: ThrottlerStorage, reflector: Reflector) => {
        return new GlobalThrottlerGuard(
            [{ ttl: 60000, limit: 5 }],
            storage,
            reflector,
        );
      },
      inject: [ThrottlerStorage, Reflector],
    },
  ],
})
export class AppModule implements NestModule {
  /**
   * Configures middleware for the application.
   *
   * @param {MiddlewareConsumer} consumer - Provides methods to apply middleware
   *                                        to controllers or routes.
   */
  configure(consumer: MiddlewareConsumer) {
    // Apply the logger middleware globally (to all routes)
    // consumer.apply(TraceIdMiddleware).forRoutes('*');
  }
}
