/**
 @file        <file name>
 @description  <description>
 @author      <Your Name>
 @created     <YYYY-MM-DD>
**/
import { Test, TestingModule } from '@nestjs/testing';
import { AppModule } from './app.module';
import { AppService } from './app.service';
import { AppController } from './app.controller';
import { HealthCheckModule } from './health-check/health-check.module';
import { ThrottlerStorage } from '@nestjs/throttler';
import { Reflector } from '@nestjs/core';
import { MicroserviceModule } from './microservices/microservice.module';
import { HospitalModule } from './hospital/hospital.module';
import { DoctorModule } from './doctor/doctor.module';

describe('AppModule', () => {
  let module: TestingModule;

  beforeEach(async () => {
    module = await Test.createTestingModule({
      imports: [AppModule],
    }).compile();
  });

  it('should compile AppModule successfully', async () => {
    expect(module).toBeDefined();
  });

  it('should resolve AppService', () => {
    const appService = module.get<AppService>(AppService);
    expect(appService).toBeDefined();
  });

  it('should resolve AppController', () => {
    const appController = module.get<AppController>(AppController);
    expect(appController).toBeDefined();
  });

  it('should resolve ThrottlerStorage for APP_GUARD injection', async () => {
    const throttlerStorage = module.get<ThrottlerStorage>(ThrottlerStorage);
    expect(throttlerStorage).toBeDefined();
  });

  it('should resolve Reflector for APP_GUARD injection', async () => {
    const reflector = module.get<Reflector>(Reflector);
    expect(reflector).toBeDefined();
  });

  it('should include all submodules', () => {
    expect(module.select(HealthCheckModule)).toBeDefined();
    expect(module.select(MicroserviceModule)).toBeDefined();
    expect(module.select(HospitalModule)).toBeDefined();
    expect(module.select(DoctorModule)).toBeDefined();
  });
});
