/**
 @file        <file name>
 @description  <description>
 @author      <Your Name>
 @created     <YYYY-MM-DD>
**/

import { Injectable } from '@nestjs/common';
import { PrismaClient } from '@prisma/client';
import {
  setEncryptedFields,
  createExtendedPrisma,
  Logger,
} from 'nest-common-utilities';
import encryptedFields from '../config/prisma.config';

/**
 * Custom Prisma service that sets up
 * encryption and extensions using `nest-common-utilities`.
 */
@Injectable()
export class PrismaService extends PrismaClient {
  private readonly logger = new Logger(PrismaService.name);

  /**
   * Initializes the Prisma client with encryption settings and extensions.
   */
  constructor() {
    // Call the base PrismaClient constructor
    super({
      // log: [
      //   { emit: 'event', level: 'query' },
      //   { emit: 'event', level: 'info' },
      //   { emit: 'event', level: 'warn' },
      //   { emit: 'event', level: 'error' },
      // ],
    });

    // if (process.env.NODE_ENV == 'dev') {
    //   this.$on('query' as never, (e: Prisma.QueryEvent) => {
    //     this.logger.info(`Query: ${e.query} | Params: ${e.params}`);
    //   });
    // }

    // Set encrypted field configuration from the app's config
    setEncryptedFields(encryptedFields);

    // Apply Prisma extensions and enhancements to this instance
    const extended = createExtendedPrisma(this);

    // Merge the extended client into this instance
    Object.assign(this, extended);
  }
}
