/**
 @file        <file name>
 @description  <description>
 @author      <Your Name>
 @created     <YYYY-MM-DD>
**/
import { Transport } from '@nestjs/microservices';
import { MICROSERVICE_CONFIGS } from './microservices.config';
import { ClientProxyWrapper,
  ClientProxyFactory,
} from 'nest-common-utilities'; // Assuming this is your wrapper class
import { Provider } from '@nestjs/common';

// export const generateClientRegistrations = (): ClientProviderOptions[] => {
//   return MICROSERVICE_CONFIGS.map(({ name, host, port }) => ({
//     name,
//     transport: Transport.TCP,
//     options: { host, port },
//   }));
// };

export const CustomClientProviders: Provider[] = MICROSERVICE_CONFIGS.map(
    (service) => ({
      provide: service.name,
      useFactory: () => {
        const client = ClientProxyFactory.create({
          transport: Transport.TCP,
          options: {
            host: service.host,
            port: service.port,
          },
        });
        return new ClientProxyWrapper(client);
      },
    }),
);
