/**
 @file        <file name>
 @description  <description>
 @author      <Your Name>
 @created     <YYYY-MM-DD>
**/

import {
  IsString,
  IsEmail,
  IsOptional,
  IsNumber,
  IsUUID,
  IsNotEmpty,
  IsArray,
} from 'class-validator';
import { ApiProperty } from '@nestjs/swagger';
import { Type } from 'class-transformer';

/**
 *
 */
export class UpdateDoctorRequestDto {
  @IsUUID()
  @IsNotEmpty({ message: 'Doctor ID must be a valid UUID' })
  @ApiProperty({ example: 'uuid', description: 'Doctor ID' })
  doctorId: string;

  @ApiProperty({
    description: 'UUID of the user who updates the doctor record',
    example: 'admin-uuid-1234',
  })
  @IsUUID()
  @IsNotEmpty({ message: 'userId is required' })
  userId: string;

  @IsNotEmpty({ message: 'Doctor name should not be empty' })
  @IsString({ message: 'Doctor name must be a string' })
  @ApiProperty({
    example: 'Dr. Prathviraj Thokal',
    description: 'Name of the doctor',
  })
  doctorName: string;

  @IsString({ message: 'Doctor registration number must be a string' })
  @IsOptional()
  @ApiProperty({
    example: 'DRREG-112',
    description: 'Registration number of the doctor',
  })
  doctorRegNo: string;

  @IsUUID()
  @IsNotEmpty({ message: 'Doctor speciality ID must be a valid UUID' })
  @ApiProperty({
    example: '2733a326-f4e2-4005-ad18-3b8f67a7613c',
    description: 'Doctor speciality ID',
  })
  doctorSpecialityId: string;

  @ApiProperty({
    description: 'List of qualification UUIDs',
    example: ['uuid1', 'uuid2'],
    required: false,
  })
  @IsOptional()
  @IsArray()
  @IsUUID('all', { each: true })
  doctorQualificationIds: string[];

  @IsOptional()
  @IsString({ message: 'Contact number must be a string' })
  @ApiProperty({
    example: '7208806389',
    description: 'Contact number of the doctor',
  })
  contactNo: string;

  @IsOptional()
  @IsString({ message: 'HPR code must be a string' })
  @ApiProperty({
    example: 'HPR-112',
    description: 'HPR code of the doctor',
  })
  hprCode: string;

  @IsOptional()
  @IsEmail({}, { message: 'Invalid email format' })
  @ApiProperty({
    example: 'niveus@example.com',
    description: 'Email of the doctor',
  })
  emailId: string;

  @IsOptional()
  @IsString({ message: 'Pan number must be a string' })
  @ApiProperty({
    example: 'HSLDY8769P',
    description: 'Pan number of the doctor',
  })
  panNo: string;

  @IsOptional()
  @IsString({ message: 'Address must be a string' })
  @ApiProperty({
    example: 'Mumbai',
    description: 'Address of the doctor',
  })
  address: string;

  @IsOptional()
  @IsUUID()
  @IsNotEmpty({ message: 'Pincode ID must be a valid UUID' })
  @ApiProperty({
    example: '2733a326-f4e2-4005-ad18-3b8f67a7613c',
    description: 'Pincode ID',
  })
  pincodeId: string;

  @IsOptional()
  @Type(() => Number)
  @IsNumber()
  @ApiProperty({
    example: 76.22222,
    description: 'Latitude',
  })
  latitude?: number;

  @IsOptional()
  @Type(() => Number)
  @IsNumber()
  @ApiProperty({
    example: 76.22222,
    description: 'Longitude',
  })
  longitude?: number;
}
