/**
 @file        <file name>
 @description  <description>
 @author      <Your Name>
 @created     <YYYY-MM-DD>
**/
import { Test, TestingModule } from '@nestjs/testing';
import { HospitalController } from './hospital.controller';
import { HospitalService } from './hospital.service';
import {
  GetHospitalsRequestDto,
} from './dto/get-hospitals/get-hospital-list-request.dto';

describe('HospitalController', () => {
  let controller: HospitalController;
  const mockHospitalService = {
    test: jest.fn(),
    getHospitalsByName: jest.fn(),
    getHospitalByHospitalId: jest.fn(),
    getHospitalByEmailId: jest.fn(),
  };

  beforeEach(async () => {
    const module: TestingModule = await Test.createTestingModule({
      controllers: [HospitalController],
      providers: [
        {
          provide: HospitalService,
          useValue: mockHospitalService,
        },
      ],
    }).compile();

    controller = module.get<HospitalController>(HospitalController);
  });

  afterEach(() => {
    jest.clearAllMocks();
  });

  describe('getHospitals()', () => {
    const mockDto = new GetHospitalsRequestDto();

    it('should return data using getHospitalsByName', async () => {
      mockDto.hospitalName = 'Test';
      const mockResponse = { list: [{}], totalCount: 1 };
      mockHospitalService.getHospitalsByName.mockResolvedValue(mockResponse);

      const result = await controller.getHospitals(mockDto);
      expect(result).toEqual(mockResponse);
    });

    it('should return data using getHospitalByHospitalId', async () => {
      mockDto.hospitalName = undefined;
      mockDto.hospitalId = 'H123';
      const mockResponse = { list: [{}], totalCount: 1 };
      mockHospitalService.getHospitalByHospitalId.mockResolvedValue(
          mockResponse,
      );

      const result = await controller.getHospitals(mockDto);
      expect(result).toEqual(mockResponse);
    });

    it('should return data using getHospitalByEmailId', async () => {
      mockDto.hospitalId = undefined;
      mockDto.emailId = 'test@example.com';
      const mockResponse = { list: [{}], totalCount: 1 };
      mockHospitalService.getHospitalByEmailId.mockResolvedValue(mockResponse);

      const result = await controller.getHospitals(mockDto);
      expect(result).toEqual(mockResponse);
    });

    it('should throw NotFoundException if no hospitals found', async () => {
      mockDto.emailId = 'noresult@example.com';
      const emptyResponse = { list: [], totalCount: 0 };
      mockHospitalService.getHospitalByEmailId.mockResolvedValue(emptyResponse);
    
      const result = await controller.getHospitals(mockDto);
      expect(result).toEqual(emptyResponse);
    });
  });
});
