/**
 @file        <file name>
 @description  <description>
 @author      <Your Name>
 @created     <YYYY-MM-DD>
**/
import { ApiProperty } from '@nestjs/swagger';
import {
  IsNotEmpty,
  IsString,
  IsUUID,
  IsOptional,
  IsEmail,
  IsArray,
} from 'class-validator';

/**
 *
 */
export class CreateDoctorDto {
  @ApiProperty({
    description: 'List of qualification UUIDs',
    example: ['uuid1', 'uuid2'],
    required: false,
  })
  @IsOptional()
  @IsArray()
  @IsUUID('all', { each: true })
  doctorQualificationIds?: string[];

  @ApiProperty({
    description: 'UUID of the doctor’s medical specialty (e.g., Cardiologist)',
    example: 'fd3a0d17-5a61-4b2f-9c88-abcdeff12345',
    required: false,
  })
  @IsUUID()
  @IsNotEmpty({ message: 'Doctor speciality is required' })
  doctorSpecialityId: string;

  @ApiProperty({
    description: 'Full name of the doctor',
    example: 'Dr. Ashwin Shetty',
  })
  @IsString()
  @IsNotEmpty({ message: 'Doctor name is required' })
  doctorName: string;

  @ApiProperty({
    description: 'Doctor\'s email address',
    example: 'ashwin.shetty@healthcare.com',
    required: false,
  })
  @IsOptional()
  @IsEmail({}, { message: 'Invalid email address' })
  emailId?: string;

  @ApiProperty({
    description: 'Doctor\'s contact number',
    example: '9876543210',
    required: false,
  })
  @IsOptional()
  @IsString()
  contactNo?: string;

  @ApiProperty({
    description: 'Doctor registration number',
    example: 'HR100928',
    required: false,
  })
  @IsOptional()
  @IsString()
  doctorRegNo?: string;

  @ApiProperty({
    description: 'HPR code',
    example: 'ADCVB987GH',
    required: false,
  })
  @IsOptional()
  @IsString()
  hprCode?: string;

  @ApiProperty({
    description: 'PAN number',
    example: 'CHPI789323',
    required: false,
  })
  @IsOptional()
  @IsString()
  panNo?: string;

  @ApiProperty({
    description: 'Doctor address',
    example: 'Marol 5th main',
    required: false,
  })
  @IsOptional()
  @IsString()
  address?: string;

  @ApiProperty({
    description: 'UUID of the Pincode Master record',
    example: '1a2b3c4d-5e6f-7a8b-9c0d-1e2f3a4b5c6d',
    required: false,
  })
  @IsOptional()
  @IsUUID()
  pincodeId?: string;

  @ApiProperty({
    description: 'Latitude',
    example: 14.910813,
    required: false,
  })
  @IsOptional()
  latitude?: number;

  @ApiProperty({
    description: 'Longitude',
    example: 79.910813,
    required: false,
  })
  @IsOptional()
  longitude?: number;

  @ApiProperty({
    description: 'UUID of the user who creates the doctor record',
    example: 'admin-uuid-1234',
  })
  @IsUUID()
  @IsNotEmpty({ message: 'Created_by is required' })
  created_by: string;

  @ApiProperty({
    description: 'UUID of the user who updates the doctor record',
    example: 'admin-uuid-1234',
    required: false,
  })
  @IsOptional()
  @IsUUID()
  updated_by?: string;
}
