/**
 @file        <file name>
 @description  <description>
 @author      <Your Name>
 @created     <YYYY-MM-DD>
**/
import { Controller, Get } from '@nestjs/common';
import {
  ApiOperation,
  ApiResponse,
} from '@nestjs/swagger';
import { AppService } from './app.service';
import { MessagePattern } from '@nestjs/microservices';
import { run } from './seed';
import { Logger } from 'nest-common-utilities';

/**
 * This controller handles the core routes of the application.
 * It may include routes for health checks, the home page,
 * or other basic functionality.
 */
@Controller()
export class AppController {
  private logger = new Logger(AppController.name);
  /**
   * Initializes the controller with the provided AppService instance.
   *
   * @param {AppService} appService - The service used for handling
   *                                  application logic.
   */
  constructor(private readonly appService: AppService) { }


  /**
 * Handles incoming 'ping' messages from a microservice.
 *
 * This method responds to a 'ping' message by returning 'pong',
 * typically used for health checks or testing message broker connectivity.
 *
 * @returns {string} A response string 'pong'.
 */
  @MessagePattern('ping')
  ping(): string {
    return 'pong';
  }


  /**
   * Seeds the database with initial data.
   * This endpoint triggers the function which populates database.
   *
   * @returns {Promise<string>} A message indicating whether
   *  the seeding was successful or failed.
   */
  @Get('seed-db')
  @ApiOperation({ summary: 'API to seed data' })
  @ApiResponse({
    status: 200,
    description: 'Seeding successful',
  })
  @ApiResponse({
    status: 500,
    description: 'Error occurred during seeding',
  })
  async seedDb(): Promise<string> {
    try {
      await run();
      return 'Seeding successfull';
    } catch (error) {
      this.logger.error('Error in seeding', error);
      return 'Error in seeding';
    }
  }
}
