/**
 @file        <file name>
 @description  <description>
 @author      <Your Name>
 @created     <YYYY-MM-DD>
**/
import { Test, TestingModule } from '@nestjs/testing';
import { AppController } from './app.controller';
import { AppService } from './app.service';

jest.mock('./seed', () => ({
  run: jest.fn(),
}));

import { run } from './seed';

describe('AppController', () => {
  let appController: AppController;

  beforeEach(async () => {
    const app: TestingModule = await Test.createTestingModule({
      controllers: [AppController],
      providers: [AppService],
    }).compile();

    appController = app.get<AppController>(AppController);
  });

  describe('root', () => {
    it('should be defined', () => {
      expect(appController).toBeDefined();
    });
  });

  describe('ping', () => {
    it('should return "pong"', () => {
      expect(appController.ping()).toBe('pong');
    });
  });

  describe('seedDb', () => {
    it('should return success message on successful seeding', async () => {
      (run as jest.Mock).mockResolvedValueOnce(undefined);
      const result = await appController.seedDb();
      expect(result).toBe('Seeding successfull');
    });

    it('should return error message on seeding failure', async () => {
      (run as jest.Mock).mockRejectedValueOnce(new Error('Seeding failed'));
      const result = await appController.seedDb();
      expect(result).toBe('Error in seeding');
    });
  });
});
