/**
 * @file        prisma.service.ts
 * @description Custom Prisma service with encrypted field support and extended utilities applied via nest-common-utilities package.
 * @author      <Your Name>
 * @created     <YYYY-MM-DD>
 **/

import { Injectable } from '@nestjs/common';
import { PrismaClient } from '@prisma/client';
import { setEncryptedFields, createExtendedPrisma } from 'nest-common-utilities';
import encryptedFields from '../config/prisma.config';

/**
 * Custom Prisma service that sets up encryption and extensions using `nest-common-utilities`.
 */
@Injectable()
export class PrismaService extends PrismaClient {
  /**
   * Initializes the Prisma client with encryption settings and extensions.
   */
  constructor() {
    // Call the base PrismaClient constructor
    super();

    // Set encrypted field configuration from the app's config
    setEncryptedFields(encryptedFields);

    // Apply Prisma extensions and enhancements to this instance
    const extended = createExtendedPrisma(this);

    // Merge the extended client into this instance
    Object.assign(this, extended);
  }
}
