/**
 * @file        hospital.service.ts
 * @description Service to handle hospital-related business logic including user fuzzy search operations.
 * @author      <Your Name>
 * @created     <YYYY-MM-DD>
 **/

import { Injectable } from '@nestjs/common';
import { PrismaService } from '../prisma/prisma.service';
import { fuzzySearch, FuzzySearchResult } from 'nest-common-utilities';
import type { user } from '@prisma/client';

/**
 * Service to encapsulate hospital domain logic such as user search.
 */
@Injectable()
export class HospitalService {
    /**
     * Constructs the HospitalService.
     * 
     * @param prisma - The Prisma service for database interactions.
     */
    constructor(private readonly prisma: PrismaService) { }

    /**
     * Executes a fuzzy search on the user table using the term 'ros'.
     * 
     * @returns A list of users matching the search criteria.
     */
    async test(): Promise<FuzzySearchResult<user>> {
        const data = await fuzzySearch<user>(this.prisma, 'user', {
            searchFields: ['name'],
            searchTerm: 'ros',
            limit: 10,
            offset: 0
        });

        console.log("Fuzzy search result:", data);
        return data;
    }
}
