/**
 * @file        hospital.controller.ts
 * @description Handles HTTP requests related to hospital operations.
 * @author      <Your Name>
 * @created     <YYYY-MM-DD>
 **/

import { Controller, HttpStatus, Post, HttpException } from '@nestjs/common';
import { Cacheable, Logger } from 'nest-common-utilities';
import { HospitalService } from './hospital.service';

/**
 * Controller to manage hospital-related API endpoints.
 */
@Controller('hospital')
export class HospitalController {
    private logger = new Logger(HospitalController.name);

    /**
     * Initializes the HospitalController.
     * 
     * @param hospitalService - Service for handling hospital business logic.
     */
    constructor(private readonly hospitalService: HospitalService) { }

    /**
     * Endpoint to create a hospital entry (test operation).
     * Logs a user creation attempt and calls the hospital service.
     * 
     * @returns The result of the hospital service test method.
     * @throws HttpException if no users are found.
     */
    @Post()
    @Cacheable((req) => JSON.stringify(req.body), 50)
    async create() {
        this.logger.info("User create log:", { email: "roshanadmin@niveus.com" });

        const res = await this.hospitalService.test();

        if (!res.total) {
            throw new HttpException('User not found', HttpStatus.BAD_GATEWAY);
        }

        return res;
    }
}
