/**
 @file        <file name>
 @description  <description>
 @author      <Your Name>
 @created     <YYYY-MM-DD>
**/
import { Controller, Get } from '@nestjs/common';
import {
  HealthCheckService,
  HealthCheck,
  HttpHealthIndicator,
} from '@nestjs/terminus';

/**
 * Controller that provides a health check endpoint for monitoring the application's health status.
 * Utilizes `@nestjs/terminus` to check the health of services like HTTP endpoints.
 */
@Controller('health-check')
export class HealthCheckController {
  /**
   * Initializes the HealthCheckService and HttpHealthIndicator to perform health checks.
   * 
   * @param {HealthCheckService} health - The service responsible for handling health checks.
   * @param {HttpHealthIndicator} http - The indicator used to check the health of HTTP endpoints.
   */
  constructor(
    private health: HealthCheckService,
    private http: HttpHealthIndicator,
  ) {}

  /**
   * Performs the health check by pinging an HTTP endpoint (in this case, Google).
   * 
   * @returns {Promise<any>} The health check result.
   */
  @Get()
  @HealthCheck()
  check() {
    // Perform a health check by pinging the Google homepage
    return this.health.check([
      () => this.http.pingCheck('google', 'https://www.google.com'),
    ]);
  }
}

