/**
 @file        <file name>
 @description  <description>
 @author      <Your Name>
 @created     <YYYY-MM-DD>
**/
import { Controller, Get } from '@nestjs/common';
import { AppService } from './app.service';
import { MessagePattern, Payload } from '@nestjs/microservices';


/**
 * This controller handles the core routes of the application.
 * It may include routes for health checks, the home page, or other basic functionality.
 */
@Controller()
export class AppController {
  /**
 * Initializes the controller with the provided AppService instance.
 *
 * @param {AppService} appService - The service used for handling application logic.
 */
  constructor(private readonly appService: AppService) { }


  /**
 * Handles incoming 'ping' messages from a microservice.
 *
 * This method responds to a 'ping' message by returning 'pong',
 * typically used for health checks or testing message broker connectivity.
 *
 * @returns {string} A response string 'pong'.
 */
  @MessagePattern('ping')
  ping(): string {
    return 'pong';
  }
}
