-- CreateEnum
CREATE TYPE "hospital_status" AS ENUM ('ACTIVE', 'SUSPENDED', 'BLOCKED');

-- CreateEnum
CREATE TYPE "account_mode" AS ENUM ('ECS', 'CHEQUE');

-- CreateEnum
CREATE TYPE "account_type" AS ENUM ('SAVINGS', 'CURRENT');

-- CreateEnum
CREATE TYPE "TariffLevel" AS ENUM ('CATEGORY', 'SUBCATEGORY', 'PROPERTY', 'SUBPROPERTY');

-- CreateEnum
CREATE TYPE "Role" AS ENUM ('user', 'admin', 'moderator');

-- CreateTable
CREATE TABLE "city_master" (
    "id" UUID NOT NULL,
    "name" TEXT NOT NULL,
    "state_id" UUID NOT NULL,
    "created_at" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "city_master_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "hospital" (
    "id" UUID NOT NULL,
    "hospital_no" TEXT NOT NULL,
    "rohini_id" TEXT NOT NULL,
    "hfr_id" TEXT NOT NULL,
    "corporate_id" UUID NOT NULL,
    "name" TEXT NOT NULL,
    "propreitor_name" TEXT NOT NULL,
    "address" TEXT NOT NULL,
    "locality" TEXT NOT NULL,
    "city_id" UUID NOT NULL,
    "state_id" UUID NOT NULL,
    "district_id" TEXT NOT NULL,
    "region_id" UUID NOT NULL,
    "pincode" TEXT NOT NULL,
    "email_id" TEXT NOT NULL,
    "bed_count" INTEGER NOT NULL,
    "pan_no_hash" TEXT NOT NULL,
    "tan_no_hash" TEXT NOT NULL,
    "contact_hash" TEXT NOT NULL,
    "website" TEXT NOT NULL,
    "is_hospital_registered" BOOLEAN NOT NULL,
    "registration_no" TEXT NOT NULL,
    "registration_authority" TEXT NOT NULL,
    "registered_from" TIMESTAMP(3) NOT NULL,
    "registered_till" TIMESTAMP(3) NOT NULL,
    "latitude" DECIMAL(9,6) NOT NULL,
    "longitude" DECIMAL(9,6) NOT NULL,
    "type_id" UUID NOT NULL,
    "level_care_id" UUID NOT NULL,
    "is_epd_enabled" BOOLEAN NOT NULL,
    "epd_discount" DECIMAL(5,2) NOT NULL,
    "epd_tat" INTEGER NOT NULL,
    "epd_effective_from" TIMESTAMP(3) NOT NULL,
    "epd_effective_till" TIMESTAMP(3) NOT NULL,
    "is_non_network" BOOLEAN NOT NULL,
    "status" "hospital_status" NOT NULL,
    "fraud_remark_id" UUID NOT NULL,
    "remarks" TEXT NOT NULL,
    "created_by" UUID NOT NULL,
    "updated_by" UUID NOT NULL,
    "created_at" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "hospital_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "hospital_accommodations" (
    "id" UUID NOT NULL,
    "hospital_id" UUID NOT NULL,
    "room_category_id" UUID NOT NULL,
    "bed_count" INTEGER NOT NULL,
    "created_at" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMP(3) NOT NULL,
    "is_active" BOOLEAN NOT NULL,

    CONSTRAINT "hospital_accommodations_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "hospital_bank_details" (
    "id" UUID NOT NULL,
    "hospital_id" UUID NOT NULL,
    "name" TEXT NOT NULL,
    "address" TEXT NOT NULL,
    "locality" TEXT NOT NULL,
    "state_id" UUID NOT NULL,
    "city_id" UUID NOT NULL,
    "district_id" TEXT NOT NULL,
    "pan_no_hash" TEXT NOT NULL,
    "tan_no_hash" TEXT NOT NULL,
    "account_type" "account_type" NOT NULL,
    "account_no_hash" TEXT NOT NULL,
    "ifsc_code" TEXT NOT NULL,
    "micr_code" TEXT NOT NULL,
    "branch_name" TEXT NOT NULL,
    "bank_name" TEXT NOT NULL,
    "payment_preference" "account_mode" NOT NULL,
    "effective_from" TIMESTAMP(3) NOT NULL,
    "effective_till" TIMESTAMP(3) NOT NULL,
    "is_active" BOOLEAN NOT NULL,
    "created_by" UUID NOT NULL,
    "updated_by" UUID NOT NULL,
    "created_at" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "hospital_bank_details_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "hospital_care_master" (
    "id" UUID NOT NULL,
    "name" TEXT NOT NULL,
    "is_active" BOOLEAN NOT NULL,
    "created_at" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "hospital_care_master_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "hospital_contact_persons" (
    "id" UUID NOT NULL,
    "hospital_id" UUID NOT NULL,
    "name" TEXT NOT NULL,
    "designation" TEXT NOT NULL,
    "mobile" TEXT NOT NULL,
    "email_id" TEXT NOT NULL,
    "created_by" UUID NOT NULL,
    "updated_by" UUID NOT NULL,
    "is_active" BOOLEAN NOT NULL,
    "created_at" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "hospital_contact_persons_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "hospital_corporate" (
    "id" UUID NOT NULL,
    "name" TEXT NOT NULL,
    "address" TEXT NOT NULL,
    "locality" TEXT NOT NULL,
    "state_id" UUID NOT NULL,
    "city_id" UUID NOT NULL,
    "district_id" TEXT NOT NULL,
    "region_id" UUID NOT NULL,
    "pincode" TEXT NOT NULL,
    "email_id" TEXT NOT NULL,
    "website" TEXT NOT NULL,
    "contact_hash" TEXT NOT NULL,
    "latitude" DECIMAL(9,6) NOT NULL,
    "longitude" DECIMAL(9,6) NOT NULL,
    "contact_no" TEXT NOT NULL,
    "created_by" UUID NOT NULL,
    "updated_by" UUID NOT NULL,
    "created_at" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "hospital_corporate_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "hospital_discount_master" (
    "id" UUID NOT NULL,
    "name" TEXT NOT NULL,
    "is_active" BOOLEAN NOT NULL,
    "created_at" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "hospital_discount_master_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "hospital_discounts" (
    "id" UUID NOT NULL,
    "hospital_id" UUID NOT NULL,
    "discount_id" UUID NOT NULL,
    "discount" DECIMAL(5,2) NOT NULL,
    "effective_from" TIMESTAMP(3) NOT NULL,
    "effective_till" TIMESTAMP(3) NOT NULL,
    "created_by" UUID NOT NULL,
    "updated_by" UUID NOT NULL,
    "created_at" TIMESTAMP(3) NOT NULL,
    "updated_at" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "hospital_discounts_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "hospital_fraud_remarks_master" (
    "id" UUID NOT NULL,
    "name" TEXT NOT NULL,
    "is_active" BOOLEAN NOT NULL,
    "created_at" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "hospital_fraud_remarks_master_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "hospital_room_categories" (
    "id" UUID NOT NULL,
    "name" TEXT NOT NULL,
    "room_id" UUID NOT NULL,
    "is_active" BOOLEAN NOT NULL,
    "created_at" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "hospital_room_categories_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "hospital_room_types" (
    "id" UUID NOT NULL,
    "name" TEXT NOT NULL,
    "is_active" BOOLEAN NOT NULL,
    "created_at" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "hospital_room_types_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "hospital_specialities" (
    "id" UUID NOT NULL,
    "hospital_id" UUID NOT NULL,
    "speciality_id" UUID NOT NULL,
    "is_active" BOOLEAN NOT NULL,
    "created_at" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "hospital_specialities_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "hospital_specialty_master" (
    "id" UUID NOT NULL,
    "name" TEXT NOT NULL,
    "is_active" BOOLEAN NOT NULL,
    "created_at" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "hospital_specialty_master_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "hospital_tariff_master" (
    "id" UUID NOT NULL,
    "name" TEXT NOT NULL,
    "parent_id" UUID,
    "level" "TariffLevel" NOT NULL,
    "is_active" BOOLEAN NOT NULL,
    "created_at" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "hospital_tariff_master_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "hospital_tariff_type_master" (
    "id" UUID NOT NULL,
    "name" TEXT NOT NULL,
    "is_active" BOOLEAN NOT NULL,
    "created_at" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "hospital_tariff_type_master_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "hospital_tariffs" (
    "id" UUID NOT NULL,
    "hospital_id" UUID NOT NULL,
    "tariff_id" UUID NOT NULL,
    "tariff_category_id" UUID NOT NULL,
    "tariff_sub_category_id" UUID NOT NULL,
    "tariff_property_id" UUID NOT NULL,
    "tariff_sub_property_id" UUID NOT NULL,
    "tariff_type_id" UUID NOT NULL,
    "effective_from" TIMESTAMP(3) NOT NULL,
    "effective_till" TIMESTAMP(3) NOT NULL,
    "created_by" UUID NOT NULL,
    "updated_by" UUID NOT NULL,
    "created_at" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "hospital_tariffs_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "hospital_type_master" (
    "id" UUID NOT NULL,
    "name" TEXT NOT NULL,
    "is_active" BOOLEAN NOT NULL,
    "created_at" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "hospital_type_master_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "hospital_zone_master" (
    "id" UUID NOT NULL,
    "name" TEXT NOT NULL,
    "is_active" BOOLEAN NOT NULL,
    "created_at" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "hospital_zone_master_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "state_master" (
    "id" UUID NOT NULL,
    "name" TEXT NOT NULL,
    "abbv" TEXT NOT NULL,
    "created_at" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "state_master_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "user" (
    "id" UUID NOT NULL,
    "name" TEXT NOT NULL,
    "email" TEXT NOT NULL,
    "hashemail" TEXT NOT NULL,
    "password" TEXT NOT NULL,
    "role" "Role" NOT NULL,
    "created_at" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "user_pkey" PRIMARY KEY ("id")
);

-- CreateIndex
CREATE UNIQUE INDEX "hospital_hospital_no_key" ON "hospital"("hospital_no");

-- CreateIndex
CREATE UNIQUE INDEX "hospital_rohini_id_key" ON "hospital"("rohini_id");

-- CreateIndex
CREATE UNIQUE INDEX "hospital_hfr_id_key" ON "hospital"("hfr_id");

-- CreateIndex
CREATE UNIQUE INDEX "user_email_key" ON "user"("email");

-- AddForeignKey
ALTER TABLE "city_master" ADD CONSTRAINT "city_master_state_id_fkey" FOREIGN KEY ("state_id") REFERENCES "state_master"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital" ADD CONSTRAINT "hospital_city_id_fkey" FOREIGN KEY ("city_id") REFERENCES "city_master"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital" ADD CONSTRAINT "hospital_corporate_id_fkey" FOREIGN KEY ("corporate_id") REFERENCES "hospital_corporate"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital" ADD CONSTRAINT "hospital_created_by_fkey" FOREIGN KEY ("created_by") REFERENCES "user"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital" ADD CONSTRAINT "hospital_fraud_remark_id_fkey" FOREIGN KEY ("fraud_remark_id") REFERENCES "hospital_fraud_remarks_master"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital" ADD CONSTRAINT "hospital_level_care_id_fkey" FOREIGN KEY ("level_care_id") REFERENCES "hospital_care_master"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital" ADD CONSTRAINT "hospital_region_id_fkey" FOREIGN KEY ("region_id") REFERENCES "hospital_zone_master"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital" ADD CONSTRAINT "hospital_state_id_fkey" FOREIGN KEY ("state_id") REFERENCES "state_master"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital" ADD CONSTRAINT "hospital_type_id_fkey" FOREIGN KEY ("type_id") REFERENCES "hospital_type_master"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital" ADD CONSTRAINT "hospital_updated_by_fkey" FOREIGN KEY ("updated_by") REFERENCES "user"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_accommodations" ADD CONSTRAINT "hospital_accommodations_hospital_id_fkey" FOREIGN KEY ("hospital_id") REFERENCES "hospital"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_accommodations" ADD CONSTRAINT "hospital_accommodations_room_category_id_fkey" FOREIGN KEY ("room_category_id") REFERENCES "hospital_room_categories"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_bank_details" ADD CONSTRAINT "hospital_bank_details_city_id_fkey" FOREIGN KEY ("city_id") REFERENCES "city_master"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_bank_details" ADD CONSTRAINT "hospital_bank_details_created_by_fkey" FOREIGN KEY ("created_by") REFERENCES "user"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_bank_details" ADD CONSTRAINT "hospital_bank_details_hospital_id_fkey" FOREIGN KEY ("hospital_id") REFERENCES "hospital"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_bank_details" ADD CONSTRAINT "hospital_bank_details_state_id_fkey" FOREIGN KEY ("state_id") REFERENCES "state_master"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_bank_details" ADD CONSTRAINT "hospital_bank_details_updated_by_fkey" FOREIGN KEY ("updated_by") REFERENCES "user"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_contact_persons" ADD CONSTRAINT "hospital_contact_persons_created_by_fkey" FOREIGN KEY ("created_by") REFERENCES "user"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_contact_persons" ADD CONSTRAINT "hospital_contact_persons_hospital_id_fkey" FOREIGN KEY ("hospital_id") REFERENCES "hospital"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_contact_persons" ADD CONSTRAINT "hospital_contact_persons_updated_by_fkey" FOREIGN KEY ("updated_by") REFERENCES "user"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_corporate" ADD CONSTRAINT "hospital_corporate_city_id_fkey" FOREIGN KEY ("city_id") REFERENCES "city_master"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_corporate" ADD CONSTRAINT "hospital_corporate_created_by_fkey" FOREIGN KEY ("created_by") REFERENCES "user"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_corporate" ADD CONSTRAINT "hospital_corporate_region_id_fkey" FOREIGN KEY ("region_id") REFERENCES "hospital_zone_master"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_corporate" ADD CONSTRAINT "hospital_corporate_state_id_fkey" FOREIGN KEY ("state_id") REFERENCES "state_master"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_corporate" ADD CONSTRAINT "hospital_corporate_updated_by_fkey" FOREIGN KEY ("updated_by") REFERENCES "user"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_discounts" ADD CONSTRAINT "hospital_discounts_created_by_fkey" FOREIGN KEY ("created_by") REFERENCES "user"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_discounts" ADD CONSTRAINT "hospital_discounts_discount_id_fkey" FOREIGN KEY ("discount_id") REFERENCES "hospital_discount_master"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_discounts" ADD CONSTRAINT "hospital_discounts_hospital_id_fkey" FOREIGN KEY ("hospital_id") REFERENCES "hospital"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_discounts" ADD CONSTRAINT "hospital_discounts_updated_by_fkey" FOREIGN KEY ("updated_by") REFERENCES "user"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_room_categories" ADD CONSTRAINT "hospital_room_categories_room_id_fkey" FOREIGN KEY ("room_id") REFERENCES "hospital_room_types"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_specialities" ADD CONSTRAINT "hospital_specialities_hospital_id_fkey" FOREIGN KEY ("hospital_id") REFERENCES "hospital"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_specialities" ADD CONSTRAINT "hospital_specialities_speciality_id_fkey" FOREIGN KEY ("speciality_id") REFERENCES "hospital_specialty_master"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_tariff_master" ADD CONSTRAINT "hospital_tariff_master_parent_id_fkey" FOREIGN KEY ("parent_id") REFERENCES "hospital_tariff_master"("id") ON DELETE SET NULL ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_tariffs" ADD CONSTRAINT "hospital_tariffs_created_by_fkey" FOREIGN KEY ("created_by") REFERENCES "user"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_tariffs" ADD CONSTRAINT "hospital_tariffs_hospital_id_fkey" FOREIGN KEY ("hospital_id") REFERENCES "hospital"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_tariffs" ADD CONSTRAINT "hospital_tariffs_tariff_category_id_fkey" FOREIGN KEY ("tariff_category_id") REFERENCES "hospital_tariff_master"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_tariffs" ADD CONSTRAINT "hospital_tariffs_tariff_id_fkey" FOREIGN KEY ("tariff_id") REFERENCES "hospital_tariff_master"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_tariffs" ADD CONSTRAINT "hospital_tariffs_tariff_property_id_fkey" FOREIGN KEY ("tariff_property_id") REFERENCES "hospital_tariff_master"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_tariffs" ADD CONSTRAINT "hospital_tariffs_tariff_sub_category_id_fkey" FOREIGN KEY ("tariff_sub_category_id") REFERENCES "hospital_tariff_master"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_tariffs" ADD CONSTRAINT "hospital_tariffs_tariff_sub_property_id_fkey" FOREIGN KEY ("tariff_sub_property_id") REFERENCES "hospital_tariff_master"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_tariffs" ADD CONSTRAINT "hospital_tariffs_tariff_type_id_fkey" FOREIGN KEY ("tariff_type_id") REFERENCES "hospital_tariff_type_master"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "hospital_tariffs" ADD CONSTRAINT "hospital_tariffs_updated_by_fkey" FOREIGN KEY ("updated_by") REFERENCES "user"("id") ON DELETE RESTRICT ON UPDATE CASCADE;
