/**
 * @file        seed.ts
 * @description Script to seed initial user data into the database using Prisma and nest-common-utilities helpers.
 * @author      <Your Name>
 * @created     <YYYY-MM-DD>
 **/

import { seedModel } from 'nest-common-utilities';
import { PrismaService } from './prisma/prisma.service';

// Instantiate Prisma service
const prisma = new PrismaService();

// Sample user data to seed into the database
const userData = [
    {
        name: 'Roshan',
        email: 'roshanadmin@niveus.com',
        hashemail: 'roshanadmin@niveus.com',
        password: '123456',
        role: 'admin'
    },
    {
        name: 'Roshanuser',
        email: 'roshanuser@niveus.com',
        hashemail: 'roshanuser@niveus.com',
        password: '123456',
        role: 'user'
    },
];

/**
 * Seeds the user model with initial data.
 */
async function run() {
    try {
        await seedModel(prisma, 'user' as keyof PrismaService, userData);
        console.log('User data seeded successfully.');
    } catch (error) {
        console.error('Error seeding user data:', error);
    } finally {
        await prisma.$disconnect();
    }
}

// Execute the seed function
run();
