/**
 @file        <file name>
 @description  <description>
 @author      <Your Name>
 @created     <YYYY-MM-DD>
**/

import { DocumentBuilder, SwaggerModule } from '@nestjs/swagger';
import { INestApplication } from '@nestjs/common';

/**
 * Sets up Swagger documentation for the NestJS application.
 *
 * This function configures and initializes Swagger UI for the API documentation.
 * It sets the title, description, version of the API, and then creates and serves
 * the Swagger UI at the `/api` endpoint.
 * 
 * @param app - The NestJS application instance.
 * @returns {void} - This method does not return any value but sets up Swagger UI.
 */
export function setupSwagger(app: INestApplication): void {
  const config = new DocumentBuilder()
    .setTitle('My Niveus HDFC ERGO API')
    .setDescription('API documentation')
    .setVersion('1.0')
    .build();

  const document = SwaggerModule.createDocument(app, config);
  SwaggerModule.setup('api', app, document);
}
