import * as fs from 'fs';

const schemaPath = 'prisma/schema.prisma';
const introspectedPath = 'prisma/introspected.prisma';

const fullSchema = fs.readFileSync(schemaPath, 'utf-8');

// Extract `datasource` block
const datasourceMatch = fullSchema.match(/datasource\s+\w+\s+\{[^}]+\}/);
if (!datasourceMatch) {
    console.error('No datasource block found in schema.prisma');
    process.exit(1);
}
const datasourceBlock = datasourceMatch[0];

// (Optional) extract generator block
const generatorMatch = fullSchema.match(/generator\s+\w+\s+\{[^}]+\}/);
const generatorBlock = generatorMatch ? generatorMatch[0] : '';

// Read introspected.prisma (or start empty)
let introspectedContent = fs.existsSync(introspectedPath)
    ? fs.readFileSync(introspectedPath, 'utf-8')
    : '';

// Remove old datasource/generator if accidentally left in
introspectedContent = introspectedContent
    .replace(/datasource\s+\w+\s+\{[^}]+\}/g, '')
    .replace(/generator\s+\w+\s+\{[^}]+\}/g, '')
    .trim();

// Write new introspected.prisma with injected header
const updated = [generatorBlock, datasourceBlock, '', introspectedContent]
    .filter(Boolean)
    .join('\n\n');

fs.writeFileSync(introspectedPath, updated, 'utf-8');
console.log('Injected datasource (and generator) into introspected.prisma');
