import jsdocPlugin from 'eslint-plugin-jsdoc';
import headerplugin from 'eslint-plugin-header';
import tseslint from 'typescript-eslint';
import globals from 'globals';
headerplugin.rules.header.meta.schema = false;

export default [
  {
    files: ['**/*.ts'],
    languageOptions: {
      ecmaVersion: 'latest',
      sourceType: 'module',
      globals: {
        // Add any NestJS-specific globals if needed
        ...globals.node,
        ...globals.jest,
      },
      parser: tseslint.parser,
      parserOptions: {
        project: './tsconfig.json',
        tsconfigRootDir: process.cwd(),
        ecmaVersion: 2021,
        sourceType: 'module'
      }
    },
    plugins: {
      '@typescript-eslint': tseslint.plugin,
      jsdoc: jsdocPlugin,
      header: headerplugin
    },
    rules: {
      // Max total lines per file
      'max-lines': ['error', {
        max: 300,
        skipBlankLines: true,
        skipComments: true
      }],

      // Max lines per function
      'max-lines-per-function': ['error', {
        max: 50,
        skipBlankLines: true,
        skipComments: true
      }],

      // Required file-level comment block with author
      'header/header': ['error', 'block', [
        '*',
        ' @file        <file name>',
        ' @description  <description>',
        ' @author      <Your Name>',
        ' @created     <YYYY-MM-DD>',
        '*'
      ]],

      // JSDoc rules
      'jsdoc/require-jsdoc': ['warn', {
        require: {
          FunctionDeclaration: true,
          MethodDefinition: true,
          ClassDeclaration: true
        }
      }],
      'jsdoc/require-description': 'warn',
      'jsdoc/require-param': 'warn',
      'jsdoc/require-returns': 'warn'
    },
    settings: {
      jsdoc: {
        mode: 'typescript'
      }
    }
  }
];
