const express = require('express')
const app = express()
require('dotenv').config();
const port = process.env.PORT || 3000

app.use(express.json());


//returns query param, path param and return both values with info as json
app.get('/api/:param', (req, res) => {
    const { param } = req.params; 
    const { query } = req.query; 
    res.json({
      pathParam: param,
      queryParam: query,
      info: 'This is a response with path and query parameters',
    });
  });
// curl --location 'http://localhost:3000/api/John?query=address'



//POST api which acccepts a JSON data. Return an array of data.
  app.post('/api/data', (req, res) => {
    const data = req.body; 
    const valuesArray = Object.values(data); 
  
    res.json({
      dataArray: valuesArray,
      info: 'Request body has been converted into an array successfully!',
    });
  });

  /*
    curl --location 'http://localhost:3000/api/data' \
--header 'Content-Type: application/json' \
--data '{
    "name": "John Doe",
    "address": "New York"
}'
*/
  

app.listen(port ,() => {
    console.log(`Server listening at http://localhost:${port}`);
  });

