const express = require('express');
const router = express.Router();
const User = require('../models/user');
const logger = require('../logger')

router.post('/', async (req, res) => {
    try {
      const user = await User.create(req.body);
      logger.info('User created:', user);
      res.status(201).json(user);
    } catch (err) {
      logger.error('Error creating user:', err.message);
      res.status(400).send(err.message);
    }
  });
  
/*
curl --location 'http://localhost:3000/api/users/' \
--header 'Content-Type: application/json' \
--data-raw '{
    "userName": "John_doe",
    "email": "john@gmail.com",
    "age": 25
}'
*/
  
  router.put('/:id', async (req, res) => {
    try {
      const user = await User.findByIdAndUpdate(req.params.id, req.body, { new: true });
      if (!user) {
        logger.error('User not found');
        return res.status(404).send('User not found');
      }
      logger.info('User updated:', user);
      res.json(user);
    } catch (err) {
      logger.error('Error updating user:', err.message);
      res.status(400).send(err.message);
    }
  });

  // set the path param to id of your document created
  /*
  curl --location --request PUT 'http://localhost:3000/api/users/660ba109fe782ca80b7b3bbb' \
--header 'Content-Type: application/json' \
--data '{
    "age": 24
}'
*/
  
  router.get('/', async (req, res) => {
    try {
      const users = await User.find();
      logger.info('Retrieved list of users:', users);
      res.json(users);
    } catch (err) {
      logger.error('Error retrieving users:', err.message);
      res.status(500).send(err.message);
    }
  });

  // curl --location 'http://localhost:3000/api/users/'
  
  module.exports = router;